/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.TextHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.Colorizable;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;
import org.openbp.cockpit.modeler.figures.generic.GeometryUtil;
import org.openbp.cockpit.modeler.figures.generic.MoveableTitleFigure;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.MultiSocketNodeFigure;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.cockpit.modeler.figures.tag.HorizontalRotatingTagFigure;
import org.openbp.cockpit.modeler.figures.tag.TagConnector;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizard;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.util.ToStringHelper;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.FinalNode;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.Param;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.gui.interaction.Importer;
import org.openbp.jaspira.gui.interaction.ViewDropRegion;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;

public class SocketFigure
extends HorizontalRotatingTagFigure
implements ProcessElementContainer,
TextHolder,
Colorizable {
    public static final String REGION_COLOR = "color";
    public static final String REGION_PARAM_BY_TYPE = "paramByType";
    public static final String REGION_PARAM_BY_VARIABLE = "paramByParay";
    protected NodeSocket socket;
    List paramList;
    private MoveableTitleFigure titleFigure;
    private LinkedList flowConnections;
    private static HiddenSocketInfo[] hiddenSockets = new HiddenSocketInfo[]{new HiddenSocketInfo("Out", NodeSocket.class, 2), new HiddenSocketInfo("In", NodeSocket.class, 2), new HiddenSocketInfo("TaskPublished", NodeSocket.class, 1), new HiddenSocketInfo("In", Node.class, 2), new HiddenSocketInfo("Out", Node.class, 2)};

    public SocketFigure(NodeFigure parent, NodeSocket socket) {
        super(parent, (Object)socket);
        this.moveBy(0, 0);
        this.layoutTag();
    }

    @Override
    protected void initContent(Object modelObject) {
        super.initContent(modelObject);
        Skin skin = this.getDrawing().getProcessSkin();
        this.socket = (NodeSocket)modelObject;
        this.socket.setRepresentation((Object)this);
        this.titleFigure = new MoveableTitleFigure((DisplayObject)this.getReferredProcessElement());
        this.titleFigure.setTitleFormat(skin.getSocketTitleFormat());
        this.titleFigure.setVerboseDisplay(true);
        this.addContent(this.titleFigure, 2);
        this.initParams();
        this.contentState = 2 | ViewModeMgr.getInstance().getTagState(this);
        if (this.paramList == null) {
            this.contentState &= 0xFFFFFFF7;
        }
        this.decodeGeometry();
    }

    private void initParams() {
        boolean showAllParams = this.socket.getProcess().getName().equals("NodeEditorDummyProcess");
        Iterator it = this.socket.getParams();
        while (it.hasNext()) {
            NodeParam param = (NodeParam)it.next();
            if (!showAllParams && !param.isVisible()) continue;
            ParamFigure paramFigure = new ParamFigure(this, param, new Point(0, 0));
            if (this.paramList == null) {
                this.paramList = new ArrayList();
            }
            this.paramList.add(paramFigure);
            this.addContent(paramFigure, 8);
        }
    }

    public void reinitParams(boolean showAllParams) {
        if (this.socket.getProcess().getName().equals("NodeEditorDummyProcess")) {
            showAllParams = true;
        }
        this.invalidate();
        int paramFigureIndex = 0;
        Iterator it = this.socket.getParams();
        while (it.hasNext()) {
            NodeParam param = (NodeParam)it.next();
            if (!param.isVisible() && !showAllParams) continue;
            if (param.getRepresentation() == null) {
                this.addParam(param, paramFigureIndex + 1);
            }
            ++paramFigureIndex;
        }
        if (!showAllParams) {
            it = this.content.iterator();
            while (it.hasNext()) {
                ParamFigure paramFigure;
                NodeParam param;
                AbstractTagFigure.TagContent content = (AbstractTagFigure.TagContent)it.next();
                if (!(content.getFigure() instanceof ParamFigure) || (param = (paramFigure = (ParamFigure)content.getFigure()).getNodeParam()).isVisible()) continue;
                it.remove();
                this.paramList.remove(paramFigure);
                param.setRepresentation(null);
            }
        }
        this.applyContentState();
        this.invalidate();
    }

    @Override
    public void applyContentState() {
        ProcessObject pe = this.getReferredProcessElement();
        String name = pe.getName();
        boolean anchorVisible = ViewModeMgr.getInstance().isControlAnchorVisible(this) || this.getDrawing().isDisplayAll();
        boolean hideText = false;
        if (!anchorVisible) {
            for (int i = 0; i < hiddenSockets.length; ++i) {
                HiddenSocketInfo info = hiddenSockets[i];
                if (!this.matchSocketName(name, info.name) || !info.objectType.isInstance(pe)) continue;
                boolean linked = this.socket.hasControlLinks();
                if ((info.constraint & 2) != 0 && !linked || (info.constraint & 1) != 0 && linked) continue;
                hideText = true;
                break;
            }
            if (pe instanceof FinalNode && ((FinalNode)pe).getJumpTarget() != null) {
                hideText = false;
            }
        }
        this.contentState = hideText ? (this.contentState &= 0xFFFFFFFD) : (this.contentState |= 2);
        super.applyContentState();
    }

    private boolean matchSocketName(String name, String pattern) {
        if (!name.startsWith(pattern)) {
            return false;
        }
        String remainder = name.substring(pattern.length());
        int l = remainder.length();
        for (int i = 0; i < l; ++i) {
            char c = remainder.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"nodeSocket");
    }

    public NodeSocket getNodeSocket() {
        return this.socket;
    }

    public boolean isEntrySocket() {
        return this.socket.isEntrySocket();
    }

    public List getFlowConnections() {
        return this.flowConnections;
    }

    public void addFlowConnection(FlowConnection connection) {
        if (this.flowConnections == null) {
            this.flowConnections = new LinkedList();
        } else if (this.flowConnections.contains(connection)) {
            return;
        }
        this.flowConnections.add(connection);
    }

    public void removeFlowConnection(FlowConnection connection) {
        if (this.flowConnections != null) {
            this.flowConnections.remove(connection);
            if (this.flowConnections.isEmpty()) {
                this.flowConnections = null;
            }
        }
    }

    public List getParamList() {
        return this.paramList;
    }

    public ParamFigure addParam(NodeParam param, int pos) {
        ParamFigure paramFigure = new ParamFigure(this, param, new Point(0, 0));
        if (pos < 0) {
            pos = this.getContent().size();
        }
        if (this.paramList == null) {
            this.paramList = new ArrayList();
        }
        this.paramList.add(pos - 1, paramFigure);
        this.addContentAt(paramFigure, pos, 8);
        this.setContentState(this.getContentState() | 8);
        paramFigure.setAngle(this.getAngle());
        return paramFigure;
    }

    public void removeParam(ParamFigure paramFigure) {
        this.willChange();
        this.socket.removeParam(paramFigure.getNodeParam());
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            AbstractTagFigure.TagContent content = (AbstractTagFigure.TagContent)it.next();
            if (content.getFigure() != paramFigure) continue;
            if (this.paramList != null) {
                this.paramList.remove(content.getFigure());
                if (this.paramList.isEmpty()) {
                    this.paramList = null;
                }
            }
            it.remove();
            break;
        }
        this.applyContentState();
        this.changed();
    }

    public void moveParameter(int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        if (oldIndex < newIndex) {
            --newIndex;
        }
        this.paramList.add(newIndex, this.paramList.remove(oldIndex));
        List socketParams = this.socket.getParamList();
        socketParams.add(newIndex, socketParams.remove(oldIndex));
        this.moveContent(oldIndex + 1, newIndex + 1);
        this.getDrawing().getEditor().view().clearSelection();
        this.getDrawing().setModified();
    }

    protected void removeConnections() {
        if (this.paramList != null) {
            Iterator it = this.paramList.iterator();
            while (it.hasNext()) {
                ((ParamFigure)it.next()).removeConnections();
            }
        }
        while (this.flowConnections != null && !this.flowConnections.isEmpty()) {
            FlowConnection connection = (FlowConnection)this.flowConnections.getFirst();
            this.getDrawing().remove(connection);
            connection.release();
        }
    }

    @Override
    public void basicSetAngle(double angle) {
        super.basicSetAngle(angle);
        for (AbstractTagFigure.TagContent next : this.content) {
            if (!(next.getFigure() instanceof AbstractTagFigure)) continue;
            ((AbstractTagFigure)next.getFigure()).setAngle(angle);
        }
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new TagConnector(this);
    }

    @Override
    public boolean canConnect() {
        if (this.isEntrySocket()) {
            return true;
        }
        if (this.flowConnections == null || this.flowConnections.isEmpty()) {
            return true;
        }
        return this.socket.getNode().isMultiExitLinkNode();
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.presentationFigure.containsPoint(x, y)) {
            return true;
        }
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            if (!fe.nextFigure().containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    public void release() {
        this.removeConnections();
        if (this.getParent() instanceof MultiSocketNodeFigure) {
            ((MultiSocketNodeFigure)this.getParent()).removeSocket(this);
        }
        super.release();
    }

    public void decodeGeometry() {
        String geometry = this.socket.getGeometry();
        if (geometry == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(geometry, "|");
        while (tok.hasMoreTokens()) {
            this.decodeParameter(tok.nextToken());
        }
    }

    protected void decodeParameter(String parameter) {
        String errIdent = this.socket.getQualifier().toUntypedString();
        StringTokenizer st = new StringTokenizer(parameter, ":");
        String paramName = st.nextToken();
        if (paramName.equals("angle")) {
            this.setAngle(GeometryUtil.parseAngle(st, paramName, errIdent));
        } else if (paramName.equals("fillcolor")) {
            this.setFillColor(GeometryUtil.parseColor(st, paramName, errIdent));
        } else {
            throw new GeometryException("Unknown paramter '" + paramName + "'.", errIdent);
        }
    }

    public void encodeGeometry() {
        String geometry = "angle:" + GeometryUtil.printAngle(this.angle);
        Color c = this.getFillColor();
        if (c != null) {
            geometry = geometry + "|fillcolor:" + c.getRed() + ":" + c.getGreen() + ":" + c.getBlue();
        }
        this.socket.setGeometry(geometry);
        if (this.paramList != null) {
            Iterator it = this.paramList.iterator();
            while (it.hasNext()) {
                ((ParamFigure)it.next()).encodeGeometry();
            }
        }
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.socket;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        Node node = this.socket.getNode();
        if (node instanceof InitialNode || node instanceof FinalNode) {
            return node;
        }
        return this.socket;
    }

    @Override
    public Figure selectionOnDelete() {
        return this.parent;
    }

    @Override
    public ProcessElementContainer findProcessElementContainer(int x, int y) {
        if (this.paramList != null && (this.getContentState() & 8) != 0) {
            for (ProcessElementContainer element : this.paramList) {
                if (!element.containsPoint(x, y)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public ProcessElementContainer findProcessElementContainerInside(int x, int y) {
        ProcessElementContainer pec = this.findProcessElementContainer(x, y);
        return pec != null ? pec.findProcessElementContainerInside(x, y) : this;
    }

    public Rectangle textDisplayBox() {
        if (this.titleFigure != null) {
            return this.titleFigure.displayBox();
        }
        return this.displayBox();
    }

    public String getText() {
        return this.getProcessElement().getName();
    }

    public void setText(String newText) {
        this.getProcessElement().setName(newText);
    }

    public boolean acceptsTyping() {
        return true;
    }

    public int overlayColumns() {
        String text = this.getText();
        int columns = 20;
        if (text != null && text.length() > 17) {
            columns = text.length() + 3;
        }
        return columns;
    }

    public void connect(Figure connectedFigure) {
    }

    public void disconnect(Figure disconnectFigure) {
    }

    public Font getFont() {
        return ModelerGraphics.getStandardTextFont();
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        DrawingEditorPlugin editor;
        boolean checkState = false;
        if (event.type == "UpdateState") {
            checkState = true;
        } else if (event.type == "SetDropTarget") {
            checkState = true;
            this.visualStatus |= 2;
        } else if (event.type == "UnsetDropTarget") {
            checkState = true;
            this.visualStatus &= 0xFFFFFFFD;
        } else if (event.type == "DoubleClick" && (editor = this.getDrawing().getEditor()) instanceof Modeler) {
            ParamValueWizard.displayParameterValueWizard((Modeler)editor, (NodeFigure)this.getParent(), this.socket.getName(), null);
            return true;
        }
        if (checkState && !ViewModeMgr.getInstance().isControlAnchorVisible(this)) {
            this.checkDecoratedContentState();
            return true;
        }
        return false;
    }

    @Override
    public void updatePresentationFigure() {
        this.presentationFigure.willChange();
        this.origin = new Point(this.parent.center());
        this.encodeGeometry();
        this.initPresentationFigure();
        this.decodeGeometry();
        this.layoutTag();
        this.presentationFigure.changed();
    }

    @Override
    public Color getDefaultFillColor() {
        return this.presentationFigure.getDefaultFillColor();
    }

    @Override
    public void dragStarted(Transferable transferable) {
        if (transferable.isDataFlavorSupported(ModelerFlavors.COLOR) || transferable.isDataFlavorSupported(ClientFlavors.TYPE_ITEM)) {
            this.handleEvent(new VisualElementEvent("SetDropTarget", this.getDrawing().getEditor()));
        }
        super.dragStarted(transferable);
    }

    @Override
    public void dragEnded(Transferable transferable) {
        if (transferable.isDataFlavorSupported(ModelerFlavors.COLOR) || transferable.isDataFlavorSupported(ClientFlavors.TYPE_ITEM)) {
            this.handleEvent(new VisualElementEvent("UnsetDropTarget", this.getDrawing().getEditor()));
        }
        super.dragEnded(transferable);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        WorkspaceDrawingView view = this.getDrawing().getView();
        if (flavors.contains(ModelerFlavors.COLOR)) {
            Rectangle r = this.presentationFigure.displayBox();
            r = view.applyScale(r, false);
            return Collections.singletonList(new ViewDropRegion(REGION_COLOR, this, r, (Component)((Object)view)));
        }
        String regionId = null;
        if (flavors.contains(ClientFlavors.TYPE_ITEM)) {
            regionId = REGION_PARAM_BY_TYPE;
        } else if (flavors.contains(ClientFlavors.PROCESS_VARIABLE)) {
            regionId = REGION_PARAM_BY_VARIABLE;
        }
        if (!(regionId == null || mouseEvent != null && mouseEvent.isControlDown())) {
            Rectangle[] bounds = this.getParamRegions();
            if (bounds.length > 1) {
                ArrayList<ViewDropRegion> result = new ArrayList<ViewDropRegion>();
                for (int i = 0; i < bounds.length; ++i) {
                    Rectangle r = view.applyScale(bounds[i], false);
                    ViewDropRegion region = new ViewDropRegion(regionId + ":" + i, this, r, (Component)((Object)view));
                    region.setPaint(ModelerColors.DROP_REGION);
                    region.setFrameColor(Color.BLACK);
                    result.add(region);
                }
                return result;
            }
            Rectangle r = this.presentationFigure.displayBox();
            r = view.applyScale(r, false);
            ViewDropRegion region = new ViewDropRegion(regionId, this, r, (Component)((Object)view));
            region.setPaint(ModelerColors.DROP_REGION);
            return Collections.singletonList(region);
        }
        return null;
    }

    public Rectangle[] getParamRegions() {
        int nParams;
        int n = nParams = this.paramList != null ? this.paramList.size() : 0;
        if ((this.getContentState() & 8) == 0) {
            nParams = 0;
        }
        Rectangle[] result = new Rectangle[nParams + 1];
        if (nParams > 0) {
            Rectangle db = this.presentationFigure.displayBox();
            if (this.isVerticalOrientation()) {
                if (this.angle >= Math.PI) {
                    int y = db.y;
                    if (this.paramList != null) {
                        for (int i = nParams; i > 0; --i) {
                            ParamFigure paramFigure = (ParamFigure)this.paramList.get(i - 1);
                            Rectangle r = new Rectangle(db.x, y, db.width, 0);
                            y = (int)paramFigure.displayBox().getCenterY();
                            r.add(db.x, y);
                            result[i] = r;
                        }
                    }
                    Rectangle r = new Rectangle(db.x, y, db.width, 0);
                    r.add(db.x, db.y + db.height);
                    result[0] = r;
                } else {
                    int y = db.y;
                    if (this.paramList != null) {
                        for (int i = 0; i < nParams; ++i) {
                            ParamFigure paramFigure = (ParamFigure)this.paramList.get(i);
                            Rectangle r = new Rectangle(db.x, y, db.width, 0);
                            y = (int)paramFigure.displayBox().getCenterY();
                            r.add(db.x, y);
                            result[i] = r;
                        }
                    }
                    Rectangle r = new Rectangle(db.x, y, db.width, 0);
                    r.add(db.x, db.y + db.height);
                    result[nParams] = r;
                }
            } else if (this.angle >= 1.5707963267948966 && this.angle < 4.71238898038469) {
                int x = db.x;
                if (this.paramList != null) {
                    for (int i = nParams; i > 0; --i) {
                        ParamFigure paramFigure = (ParamFigure)this.paramList.get(i - 1);
                        Rectangle r = new Rectangle(x, db.y, 0, db.height);
                        x = (int)paramFigure.displayBox().getCenterX();
                        r.add(x, db.y);
                        result[i] = r;
                    }
                }
                Rectangle r = new Rectangle(x, db.y, 0, db.height);
                r.add(db.x + db.width, db.y);
                result[0] = r;
            } else {
                int x = db.x;
                if (this.paramList != null) {
                    for (int i = 0; i < nParams; ++i) {
                        ParamFigure paramFigure = (ParamFigure)this.paramList.get(i);
                        Rectangle r = new Rectangle(x, db.y, 0, db.height);
                        x = (int)paramFigure.displayBox().getCenterX();
                        r.add(x, db.y);
                        result[i] = r;
                    }
                }
                Rectangle r = new Rectangle(x, db.y, 0, db.height);
                r.add(db.x + db.width, db.y);
                result[nParams] = r;
            }
        } else {
            result[0] = this.presentationFigure.displayBox();
        }
        return result;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        try {
            if (REGION_COLOR.equals(regionId)) {
                Color color = (Color)data.getTransferData(ModelerFlavors.COLOR);
                this.getDrawing().getEditor().startUndo("Set Color");
                this.setFillColor(color);
                this.invalidate();
                this.getDrawing().getEditor().endUndo();
            } else {
                String regionStr = (String)regionId;
                String paramName = null;
                DataTypeItem paramType = null;
                ProcessVariable processVariable = null;
                if (regionStr.startsWith(REGION_PARAM_BY_TYPE)) {
                    paramType = (DataTypeItem)data.getTransferData(ClientFlavors.TYPE_ITEM);
                    paramName = paramType.getName();
                } else if (regionStr.startsWith(REGION_PARAM_BY_VARIABLE)) {
                    processVariable = (ProcessVariable)data.getTransferData(ClientFlavors.PROCESS_VARIABLE);
                    paramType = processVariable.getDataType();
                    paramName = processVariable.getName();
                    if (this.socket.getParamByName(paramName) != null) {
                        String msg = "The socket already has a parameter named '" + paramName + "'.\nPlease connect the process variable to the existing parameter.";
                        JMsgBox.show(null, (String)msg, (int)262144);
                        return true;
                    }
                }
                int pos = this.getContent().size();
                int sepIndex = regionStr.indexOf(58);
                if (sepIndex > 0) {
                    pos = Integer.parseInt(regionStr.substring(sepIndex + 1)) + 1;
                }
                this.getDrawing().getEditor().startUndo("Add Parameter");
                NodeParam param = this.socket.createParam(paramName);
                param.setDataType(paramType);
                this.socket.addParam(param, pos - 1);
                param.maintainReferences(5);
                ParamFigure paramFigure = this.addParam(param, pos);
                ((WorkspaceDrawingView)this.getDrawing().getEditor().view()).singleSelect(paramFigure);
                if (processVariable != null) {
                    NodeParam targetParam;
                    ProcessVariable sourceParam;
                    DataLink dataLink = this.getDrawing().getProcess().createDataLink();
                    if (this.socket.isEntrySocket()) {
                        sourceParam = processVariable;
                        targetParam = param;
                    } else {
                        sourceParam = param;
                        targetParam = processVariable;
                    }
                    dataLink.link((Param)sourceParam, (Param)targetParam);
                    this.getDrawing().getProcess().addDataLink(dataLink);
                    paramFigure.setProcessVariableConnection(processVariable, dataLink);
                }
                this.getDrawing().getEditor().endUndo();
                this.getDrawing().getEditor().fireEvent("modeler.drawing.paramadded", paramFigure);
                ViewModeMgr.getInstance().setDataLinkVisible(true);
            }
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public List getImportersAt(Point p) {
        WorkspaceDrawingView view = this.getDrawing().getView();
        Point docPoint = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)view));
        if (this.presentationFigure.containsPoint(docPoint.x, docPoint.y)) {
            return Collections.singletonList(new Importer(this.socket.getQualifier(), this, new DataFlavor[]{ClientFlavors.TYPE_ITEM, ModelerFlavors.COLOR}));
        }
        return null;
    }

    private static class HiddenSocketInfo {
        public static final int VISIBLE_WHEN_LINKED = 1;
        public static final int VISIBLE_WHEN_NOT_LINKED = 2;
        public String name;
        public Class objectType;
        public int constraint;

        public HiddenSocketInfo(String name, Class objectType, int constraint) {
            this.name = name;
            this.objectType = objectType;
            this.constraint = constraint;
        }
    }
}

