/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractLocator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.XFontSizeHandle;
import org.openbp.cockpit.modeler.figures.generic.XTextFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.common.util.ToStringHelper;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.core.model.item.process.TextElement;
import org.openbp.jaspira.gui.interaction.Importer;
import org.openbp.jaspira.gui.interaction.ViewDropRegion;
import org.openbp.swing.SwingUtil;

public class TextElementFigure
extends XTextFigure
implements ProcessElementContainer {
    public static final String REGION_COLOR = "color";
    private TextElement textElement;
    private int visualStatus = 1;
    private ProcessDrawing drawing;

    public void connect(TextElement textElement, ProcessDrawing drawing) {
        this.setAutoSize(true);
        this.textElement = textElement;
        this.drawing = drawing;
        String text = textElement.getDescription();
        if (text == null) {
            text = "Text";
        }
        this.setText(text);
        this.decodeGeometry();
    }

    public TextElement getTextElement() {
        return this.textElement;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"textElement");
    }

    @Override
    public Vector handles() {
        Vector<XFontSizeHandle> handles = new Vector<XFontSizeHandle>();
        handles.addElement(new XFontSizeHandle(this, (Locator)new SizeHandleLocator(this)));
        return handles;
    }

    public void release() {
        super.release();
        this.getDrawing().getProcess().removeTextElement(this.textElement);
    }

    public void decodeGeometry() {
        this.parseGeometry(this.textElement.getGeometry());
    }

    public void encodeGeometry() {
        this.textElement.setGeometry(this.createGeometry());
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.textElement;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        return this.getProcessElement();
    }

    @Override
    public Figure selectionOnDelete() {
        return null;
    }

    @Override
    public ProcessElementContainer findProcessElementContainer(int x, int y) {
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    @Override
    public ProcessElementContainer findProcessElementContainerInside(int x, int y) {
        return this.findProcessElementContainer(x, y);
    }

    @Override
    public void setDrawing(ProcessDrawing drawing) {
        this.drawing = drawing;
    }

    @Override
    public ProcessDrawing getDrawing() {
        return this.drawing;
    }

    @Override
    public VisualElement getParentElement() {
        return this.getDrawing();
    }

    @Override
    public Figure getPresentationFigure() {
        return this;
    }

    @Override
    public void updatePresentationFigure() {
    }

    @Override
    public boolean isVisible() {
        return (this.visualStatus & 1) != 0;
    }

    @Override
    public void setVisible(boolean visible) {
        this.willChange();
        this.visualStatus = visible ? (this.visualStatus |= 1) : (this.visualStatus &= 0xFFFFFFFE);
        this.changed();
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        return false;
    }

    @Override
    public VisualElement findVisualElement(int x, int y) {
        return this;
    }

    @Override
    public VisualElement findVisualElementInside(int x, int y) {
        return this;
    }

    @Override
    public void updateFigure() {
        String newText = this.textElement.getDescription();
        if (newText == null) {
            newText = "Text";
        }
        this.setText(newText);
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragEnded(Transferable transferable) {
    }

    @Override
    public void dragStarted(Transferable transferable) {
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return this.getDropRegions(flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        if (flavors.contains(ModelerFlavors.COLOR)) {
            WorkspaceDrawingView view = this.getDrawing().getView();
            Rectangle r = view.applyScale(this.displayBox(), false);
            return Collections.singletonList(new ViewDropRegion(REGION_COLOR, this, r, (Component)((Object)view)));
        }
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        WorkspaceDrawingView view = this.getDrawing().getView();
        Point docPoint = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)view));
        if (this.containsPoint(docPoint.x, docPoint.y)) {
            return Collections.singletonList(new Importer(REGION_COLOR, this, new DataFlavor[]{ModelerFlavors.COLOR}));
        }
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return this.getImportersAt(p);
    }

    @Override
    public List getSubClients() {
        return null;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        try {
            if (regionId.equals(REGION_COLOR)) {
                Color color = (Color)data.getTransferData(ModelerFlavors.COLOR);
                this.getDrawing().getEditor().startUndo("Set Color");
                this.setFillColor(color);
                this.invalidate();
                this.getDrawing().getEditor().endUndo();
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    private class SizeHandleLocator
    extends AbstractLocator {
        private final Figure owner;

        public SizeHandleLocator(Figure owner) {
            this.owner = owner;
        }

        public Point locate(Figure figure) {
            Rectangle r = this.owner.displayBox();
            return new Point(r.x - 5, r.y - 5);
        }
    }
}

