/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.spline;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.figures.tag.TagConnector;
import org.openbp.common.CommonUtil;

public class ConstrainedControlPointHandle
extends AbstractHandle {
    private int splineIndex;
    private int side;
    private int distance;

    public ConstrainedControlPointHandle(PolySplineConnection owner, int splineIndex, int splineIndex2) {
        super((Figure)owner);
        this.splineIndex = splineIndex;
        this.side = splineIndex == 0 ? 1 : 0;
        Point2D p1 = owner.getPointAt(splineIndex);
        Point2D p2 = owner.getPointAt(splineIndex2);
        double xdiff = p1.getX() - p2.getX();
        double ydiff = p1.getY() - p2.getY();
        this.distance = CommonUtil.rnd((double)Math.sqrt(xdiff * xdiff + ydiff * ydiff));
    }

    private PolySplineConnection getOwningSpline() {
        return (PolySplineConnection)this.owner();
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        PolySplineConnection spline = this.getOwningSpline();
        Point p = this.locateWayPoint();
        Orientation orientation = this.splineIndex == 0 ? ((TagConnector)spline.getStartConnector()).getOrientation() : ((TagConnector)spline.getEndConnector()).getOrientation();
        boolean vertical = orientation == Orientation.TOP || orientation == Orientation.BOTTOM;
        double newFactor = vertical ? (double)Math.abs(y - p.y) : (double)Math.abs(x - p.x);
        newFactor /= (double)this.distance;
        if (this.splineIndex == 0) {
            spline.setStartFactor(newFactor);
        } else {
            spline.setEndFactor(newFactor);
        }
    }

    public Point locate() {
        Point2D splinePoint = this.getOwningSpline().getCtrlPointAt(this.splineIndex, this.side);
        return new Point(CommonUtil.rnd((double)splinePoint.getX()), CommonUtil.rnd((double)splinePoint.getY()));
    }

    protected Point locateWayPoint() {
        Point2D splinePoint = this.getOwningSpline().getPointAt(this.splineIndex);
        return new Point(CommonUtil.rnd((double)splinePoint.getX()), CommonUtil.rnd((double)splinePoint.getY()));
    }

    public Rectangle displayBox() {
        Point p = this.locate();
        return new Rectangle(p.x - 5, p.y - 5, 10, 10);
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Point p1 = this.locateWayPoint();
        Point p2 = this.locate();
        Stroke old = g2.getStroke();
        g2.setStroke(ModelerGraphics.labelHandleStroke);
        g.setColor(ModelerColors.HANDLE_LINE);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g2.setStroke(old);
        Rectangle r = this.displayBox();
        g.setColor(ModelerColors.HANDLE_WAYPOINT_FILL);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(ModelerColors.HANDLE_WAYPOINT_BORDER);
        g.drawRect(r.x, r.y, r.width, r.height);
    }
}

