/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.spline;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.openbp.cockpit.modeler.figures.spline.WayPointHandle;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.common.CommonUtil;

public class PolySplineFigure
extends AbstractFigure {
    public static final int LEFT_CONTROLPOINT = 0;
    public static final int RIGHT_CONTROLPOINT = 1;
    protected List segments;
    private LineDecoration startDecoration;
    private LineDecoration endDecoration;
    private LineDecoration animationDecoration;
    protected boolean drawDecorations = true;
    private Color frameColor = Color.BLACK;
    private Stroke stroke = FigureResources.standardStroke1;
    private Shape[] shapeCache;
    private static Stroke outlineStroke = new BasicStroke(15.0f);

    public PolySplineFigure() {
        this.segments = new LinkedList();
    }

    public Rectangle displayBox() {
        Rectangle r = this.getSplineBounds();
        r.grow(30, 30);
        return r;
    }

    public void basicDisplayBox(Point origin, Point corner) {
    }

    public boolean isEmpty() {
        return this.size().width < 3 && this.size().height < 3;
    }

    public Vector handles() {
        Vector<WayPointHandle> handles = new Vector<WayPointHandle>(this.segments.size() * 3 + 1);
        int max = this.segments.size();
        for (int i = 0; i <= max; ++i) {
            handles.add(new WayPointHandle(this, i));
        }
        return handles;
    }

    public boolean containsPoint(int x, int y) {
        return this.findSegment(x, y) != -1;
    }

    public boolean canConnect() {
        return false;
    }

    public Connector connectorAt(int x, int y) {
        return null;
    }

    protected void basicMoveBy(int dx, int dy) {
        for (CubicCurve2D next : this.segments) {
            next.setCurve(next.getX1() + (double)dx, next.getY1() + (double)dy, next.getCtrlX1() + (double)dx, next.getCtrlY1() + (double)dy, next.getCtrlX2() + (double)dx, next.getCtrlY2() + (double)dy, next.getX2() + (double)dx, next.getY2() + (double)dy);
        }
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.getStroke());
        Color oldColor = g2.getColor();
        g2.setColor(this.getFrameColor());
        this.drawSpline(g2);
        if (this.drawDecorations) {
            g.setColor(this.getFrameColor());
            this.drawDecorations(g);
        }
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    protected void drawSpline(Graphics2D g2) {
        Iterator it = this.segments.iterator();
        while (it.hasNext()) {
            g2.draw((CubicCurve2D)it.next());
        }
    }

    public Rectangle getSplineBounds() {
        if (this.segments.size() == 0) {
            return new Rectangle();
        }
        Rectangle r = new Rectangle(this.pointAt(0));
        Iterator it = this.segments.iterator();
        while (it.hasNext()) {
            r = r.union(((CubicCurve2D)it.next()).getBounds());
        }
        return r;
    }

    protected void adjustOpposite(int index, int side) {
        if (index == 0 || index >= this.segments.size()) {
            return;
        }
        Point2D p = this.getCtrlPointAt(index, side);
        Point2D center = this.getPointAt(index);
        Point2D.Double target = new Point2D.Double(2.0 * center.getX() - p.getX(), 2.0 * center.getY() - p.getY());
        if (side == 0) {
            CubicCurve2D next = (CubicCurve2D)this.segments.get(index);
            next.setCurve(next.getP1(), target, next.getCtrlP2(), next.getP2());
        } else {
            CubicCurve2D prev = (CubicCurve2D)this.segments.get(index - 1);
            prev.setCurve(prev.getP1(), prev.getCtrlP1(), target, prev.getP2());
        }
    }

    public Object getAttribute(String name) {
        if (name.equals("FrameColor")) {
            return this.getFrameColor();
        }
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("FrameColor")) {
            this.setFrameColor((Color)value);
            this.changed();
        } else {
            super.setAttribute(name, value);
        }
    }

    public int pointCount() {
        return this.segments.size() + 1;
    }

    public Point pointAt(int i) {
        Point2D p = this.getPointAt(i);
        return new Point(CommonUtil.rnd((double)p.getX()), CommonUtil.rnd((double)p.getY()));
    }

    public Point2D getPointAt(int i) {
        return i != 0 ? ((CubicCurve2D)this.segments.get(i - 1)).getP2() : ((CubicCurve2D)this.segments.get(i)).getP1();
    }

    public Point2D getCtrlPointAt(int i, int side) {
        return side != 0 ? ((CubicCurve2D)this.segments.get(i)).getCtrlP1() : ((CubicCurve2D)this.segments.get(i - 1)).getCtrlP2();
    }

    public void setPointAt(int index, Point2D target) {
        this.willChange();
        Point2D p = this.getPointAt(index);
        int dx = CommonUtil.rnd((double)(target.getX() - p.getX()));
        int dy = CommonUtil.rnd((double)(target.getY() - p.getY()));
        if (index > 0) {
            CubicCurve2D prev = (CubicCurve2D)this.segments.get(index - 1);
            p = prev.getCtrlP2();
            p.setLocation(p.getX() + (double)dx, p.getY() + (double)dy);
            prev.setCurve(prev.getP1(), prev.getCtrlP1(), p, target);
            this.basicSetCtrlPoint(index, 0, p);
        }
        if (index < this.segments.size()) {
            CubicCurve2D next = (CubicCurve2D)this.segments.get(index);
            p = next.getCtrlP1();
            p.setLocation(p.getX() + (double)dx, p.getY() + (double)dy);
            next.setCurve(target, p, next.getCtrlP2(), next.getP2());
            this.basicSetCtrlPoint(index, 1, p);
        }
        this.changed();
        this.clearShapeCache();
    }

    public void setCtrlPointAt(int index, int side, Point2D target) {
        this.willChange();
        this.basicSetCtrlPoint(index, side, target);
        this.adjustOpposite(index, side);
        this.changed();
        this.clearShapeCache();
    }

    protected void basicSetCtrlPoint(int index, int side, Point2D target) {
        target = this.constrainCtrlPoint(index, side, target);
        if (side != 0) {
            CubicCurve2D next = (CubicCurve2D)this.segments.get(index);
            next.setCurve(next.getP1(), target, next.getCtrlP2(), next.getP2());
        } else {
            CubicCurve2D prev = (CubicCurve2D)this.segments.get(index - 1);
            prev.setCurve(prev.getP1(), prev.getCtrlP1(), target, prev.getP2());
        }
    }

    public void removePoint(int i) {
        this.willChange();
        if (i == 0) {
            this.segments.remove(0);
        } else if (i == this.segments.size()) {
            this.segments.remove(this.segments.size() - 1);
        } else {
            CubicCurve2D removed = (CubicCurve2D)this.segments.remove(i);
            CubicCurve2D prev = (CubicCurve2D)this.segments.get(i - 1);
            prev.setCurve(prev.getP1(), prev.getCtrlP1(), removed.getCtrlP2(), removed.getP2());
        }
        this.changed();
        this.clearShapeCache();
    }

    protected Point2D constrainCtrlPoint(int index, int side, Point2D target) {
        return target;
    }

    protected Point2D getPointOnCurve(double position) {
        Point2D.Double ret = new Point2D.Double();
        if (this.segments.size() == 0) {
            return ret;
        }
        if (position < 0.0) {
            position = 0.0;
        }
        if (position > 1.0) {
            position = 1.0;
        }
        CubicCurve2D curve = (CubicCurve2D)this.segments.get(Math.min(this.segments.size() - 1, (int)Math.floor(position *= (double)this.segments.size())));
        double k1 = (1.0 - (position %= 1.0)) * (1.0 - position) * (1.0 - position);
        double k2 = (1.0 - position) * (1.0 - position) * position * 3.0;
        double k3 = (1.0 - position) * position * position * 3.0;
        double k4 = position * position * position;
        ((Point2D)ret).setLocation(k1 * curve.getX1() + k2 * curve.getCtrlX1() + k3 * curve.getCtrlX2() + k4 * curve.getX2(), k1 * curve.getY1() + k2 * curve.getCtrlY1() + k3 * curve.getCtrlY2() + k4 * curve.getY2());
        return ret;
    }

    public CubicCurve2D segmentAt(int i) {
        return (CubicCurve2D)this.segments.get(i);
    }

    public int findSegment(int x, int y) {
        Rectangle bounds = this.displayBox();
        bounds.grow(4, 4);
        if (!bounds.contains(x, y)) {
            return -1;
        }
        if (this.shapeCache == null) {
            this.rebuildShapeCache();
        }
        for (int i = 0; i < this.shapeCache.length; ++i) {
            if (!this.shapeCache[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected void rebuildShapeCache() {
        if (this.shapeCache != null) {
            return;
        }
        this.shapeCache = new Shape[this.segments.size()];
        for (int i = 0; i < this.shapeCache.length; ++i) {
            this.shapeCache[i] = outlineStroke.createStrokedShape(this.segmentAt(i));
        }
    }

    protected void clearShapeCache() {
        this.shapeCache = null;
    }

    public int splitSegment(int x, int y) {
        this.willChange();
        int i = this.findSegment(x, y);
        if (i != -1) {
            CubicCurve2D.Double insert = new CubicCurve2D.Double();
            CubicCurve2D prev = (CubicCurve2D)this.segments.get(i);
            prev.subdivide(prev, insert);
            this.segments.add(i + 1, insert);
            this.setPointAt(i + 1, new Point(x, y));
            this.adjustOpposite(i, 0);
            this.adjustOpposite(i + 2, 1);
        }
        this.changed();
        this.clearShapeCache();
        return i + 1;
    }

    public boolean joinSegments(int x, int y) {
        this.willChange();
        Iterator it = this.segments.iterator();
        if (it.hasNext()) {
            it.next();
            int i = 1;
            while (it.hasNext()) {
                Point2D p = ((CubicCurve2D)it.next()).getP1();
                if (Geom.length((int)x, (int)y, (int)((int)p.getX()), (int)((int)p.getY())) < 5L) {
                    this.removePoint(i);
                    return true;
                }
                ++i;
            }
        }
        this.changed();
        this.clearShapeCache();
        return false;
    }

    protected void drawDecorations(Graphics g) {
        Point2D p2;
        Point2D p1;
        if (this.getStartDecoration() != null) {
            p1 = this.getPointAt(0);
            p2 = this.getCtrlPointAt(0, 1);
            this.getStartDecoration().draw(g, CommonUtil.rnd((double)p1.getX()), CommonUtil.rnd((double)p1.getY()), CommonUtil.rnd((double)p2.getX()), CommonUtil.rnd((double)p2.getY()));
        }
        if (this.getEndDecoration() != null) {
            p1 = this.getPointAt(this.segments.size());
            p2 = this.getCtrlPointAt(this.segments.size(), 0);
            this.getEndDecoration().draw(g, CommonUtil.rnd((double)p1.getX()), CommonUtil.rnd((double)p1.getY()), CommonUtil.rnd((double)p2.getX()), CommonUtil.rnd((double)p2.getY()));
        }
    }

    public LineDecoration getStartDecoration() {
        return this.startDecoration;
    }

    public void setStartDecoration(LineDecoration startDecoration) {
        this.startDecoration = startDecoration;
    }

    public LineDecoration getEndDecoration() {
        return this.endDecoration;
    }

    public void setEndDecoration(LineDecoration endDecoration) {
        this.endDecoration = endDecoration;
    }

    public LineDecoration getAnimationDecoration() {
        return this.animationDecoration;
    }

    public void setAnimationDecoration(LineDecoration animationDecoration) {
        this.animationDecoration = animationDecoration;
    }

    public void setDrawDecorations(boolean drawDecorations) {
        this.drawDecorations = drawDecorations;
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }
}

