/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.paramvaluewizard;

import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizard;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizardPart;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.core.model.WorkflowTaskDescriptor;
import org.openbp.core.model.item.ConfigurationBean;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.WorkflowNode;
import org.openbp.jaspira.gui.wizard.JaspiraWizardObjectPage;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;

public class ConfigurationBeanPage
extends JaspiraWizardObjectPage
implements ParamValueWizardPart {
    private MultiSocketNode node;
    private ConfigurationBean configurationBean;

    public ConfigurationBeanPage(ParamValueWizard wizard, MultiSocketNode node, ConfigurationBean configurationBean) {
        super((Wizard)wizard);
        this.node = node;
        this.configurationBean = configurationBean;
        this.canMoveForward = true;
        this.canFinish = true;
    }

    @Override
    public void apply() {
        if (!this.configurationBean.hasDefaultValues()) {
            this.node.setConfigurationBean(this.configurationBean);
        }
        if (this.node instanceof WorkflowNode) {
            ((WorkflowNode)this.node).setWorkflowTaskDescriptor((WorkflowTaskDescriptor)this.configurationBean);
            this.node.setConfigurationBean(null);
        }
    }

    @Override
    public void handleWizardEvent(WizardEvent event) {
        if (event.eventType == 0) {
            try {
                this.getPropertyBrowser().setObject(this.configurationBean, true);
            }
            catch (XMLDriverException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        } else if (event.eventType == 1) {
            this.getPropertyBrowser().reset();
        }
        super.handleWizardEvent(event);
    }

    @Override
    public boolean executeSave(PropertyBrowser pb) {
        this.configurationBean = (ConfigurationBean)pb.getModifiedObject();
        return true;
    }
}

