/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class InPlaceEditingTextField {
    private JTextField editWidget = new JTextField();
    private Container container;

    public void displayOverlay(String text, Container container, Rectangle r) {
        container.add((Component)this.editWidget, 0);
        this.container = container;
        this.editWidget.setText(text);
        this.editWidget.setBounds(r.x, r.y, r.width, r.height);
        this.editWidget.setVisible(true);
        this.editWidget.selectAll();
        this.editWidget.requestFocus();
    }

    public void endOverlay() {
        if (this.container != null) {
            this.editWidget.setVisible(false);
            this.container.remove(this.editWidget);
            Rectangle bounds = this.editWidget.getBounds();
            this.container.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            this.container.requestFocus();
            this.container = null;
        }
    }

    public String getText() {
        return this.editWidget.getText();
    }

    public void setFont(Font font) {
        if (font != null) {
            this.editWidget.setFont(font);
        }
    }

    public Dimension getPreferredSize(int cols) {
        this.editWidget.setColumns(cols * 3 / 5);
        return this.editWidget.getPreferredSize();
    }

    public void addActionListener(ActionListener listener) {
        this.editWidget.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.editWidget.removeActionListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.editWidget.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.editWidget.removeKeyListener(listener);
    }
}

