/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.Figure;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.tools.InPlaceEditingTextField;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.common.string.StringUtil;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.swing.components.JMsgBox;

public class ProcessElementInPlaceEditorTool
extends ModelerTool {
    private ProcessElementContainer pec;
    private InPlaceEditingTextField textOverlay = new InPlaceEditingTextField();

    public ProcessElementInPlaceEditorTool(ModelerToolSupport toolSupport) {
        super(toolSupport);
        this.textOverlay.setFont(ModelerGraphics.getStandardTextFont());
        this.textOverlay.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 10) {
                    ProcessElementInPlaceEditorTool.this.deactivate();
                } else if (keyCode == 27) {
                    ProcessElementInPlaceEditorTool.this.cancelEdit();
                    ProcessElementInPlaceEditorTool.this.deactivate();
                }
            }
        });
    }

    @Override
    public void setAffectedObject(Object affectedObject) {
        if (affectedObject != this.getAffectedObject()) {
            this.cancelEdit();
        }
        super.setAffectedObject(affectedObject);
        this.pec = (ProcessElementContainer)affectedObject;
    }

    @Override
    public void activate() {
        super.activate();
        this.getView().setCursor(ModelerGraphics.standardCursor);
        this.beginEdit();
    }

    @Override
    public void deactivate() {
        if (this.endEdit()) {
            super.deactivate();
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        VisualElement clickedFigure = ((ProcessDrawing)this.getDrawing()).findVisualElementInside(x, y);
        if (clickedFigure instanceof ProcessElementContainer && !(clickedFigure instanceof ProcessDrawing) && e.getClickCount() == 1) {
            if (this.saveEdit()) {
                if (clickedFigure == this.pec) {
                    this.deactivate();
                } else {
                    this.pec = (ProcessElementContainer)clickedFigure;
                    this.getView().singleSelect(clickedFigure);
                    this.beginEdit();
                }
            }
        } else {
            this.deactivate();
        }
    }

    public void beginEdit() {
        if (this.pec == null) {
            return;
        }
        String text = this.pec.getReferredProcessElement().getName();
        int nChars = text != null ? text.length() : 1;
        Dimension textDim = this.textOverlay.getPreferredSize(nChars);
        Figure f = this.pec.getPresentationFigure();
        if (f == null) {
            f = this.pec;
        }
        Rectangle figureRect = f.displayBox();
        figureRect = this.getView().applyScale(figureRect, false);
        int textWidth = textDim.width;
        int figureWidth = figureRect.width;
        int w = figureWidth - 10;
        if (textWidth > w) {
            w = textWidth;
        } else if (w > 120) {
            w = 120;
        }
        if (w < 60) {
            w = 60;
        }
        int h = textDim.height;
        int x = figureRect.x;
        x = figureWidth <= 200 ? (x += figureWidth + 5) : (x += figureWidth / 2 - w / 2);
        int y = figureRect.y + figureRect.height / 2 - h / 2;
        Rectangle textRect = new Rectangle(x, y, w, h);
        Rectangle docTextRect = this.getView().applyScale(textRect, true);
        docTextRect.width += 10;
        this.getView().scrollRectToVisible(docTextRect);
        this.textOverlay.displayOverlay(text, (Container)((Object)this.getView()), textRect);
        this.getEditor().startUndo("Edit Text");
    }

    protected boolean saveEdit() {
        if (this.pec != null) {
            ProcessObject po = this.pec.getReferredProcessElement();
            String text = this.textOverlay.getText();
            text = StringUtil.trimNull((String)text);
            String msg = null;
            if (text == null) {
                msg = "An object name must not be empty.";
            } else if (!ModelQualifier.isValidIdentifier((String)text)) {
                msg = "An object name must not contain one of the characters '.', '/', ':', ';'.";
            } else if (((ProcessDrawing)this.getDrawing()).getProcess().getNodeByName(text) != null) {
                Iterator it = po.getContainerIterator();
                while (it.hasNext()) {
                    ModelObject mo = (ModelObject)it.next();
                    if (!mo.getName().equals(text) || mo == po) continue;
                    msg = "An element having this name already exists.";
                    break;
                }
            }
            if (msg != null) {
                JMsgBox.show(null, (String)msg, (int)65536);
                return false;
            }
            po.setName(text);
            this.pec.updateFigure();
            this.getView().singleSelect(this.pec);
        }
        return true;
    }

    protected boolean endEdit() {
        if (this.saveEdit()) {
            this.textOverlay.endOverlay();
            this.pec = null;
            return true;
        }
        return false;
    }

    protected void cancelEdit() {
        this.getEditor().cancelUndo();
        this.textOverlay.endOverlay();
        this.pec = null;
    }
}

