/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.TextElementFigure;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.cockpit.modeler.util.InputState;

public class RubberBandTool
extends ModelerTool {
    private Rectangle selectRect;
    private int anchorX;
    private int anchorY;

    public RubberBandTool(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public void activate() {
        if (!InputState.isShiftDown()) {
            this.getView().clearSelection();
        }
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this.getView().clearSelection();
        this.anchorX = x;
        this.anchorY = y;
        this.rubberBand(this.anchorX, this.anchorY, x, y);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        this.rubberBand(this.anchorX, this.anchorY, x, y);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        this.eraseRubberBand();
        this.selectRectangle(e.isShiftDown());
        super.mouseUp(e, x, y);
    }

    private void rubberBand(int x1, int y1, int x2, int y2) {
        this.selectRect = new Rectangle(new Point(x1, y1));
        this.selectRect.add(new Point(x2, y2));
        this.drawXORRect(this.selectRect);
    }

    public void eraseRubberBand() {
        this.drawXORRect(this.selectRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawXORRect(Rectangle r) {
        r = this.getView().applyScale(r, false);
        Graphics g = this.getView().getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.getView().getBackground());
                g.setColor(ModelerColors.RUBBERBAND);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
            finally {
                g.dispose();
            }
        }
    }

    protected void selectRectangle(boolean toggle) {
        FigureEnumeration fe = this.getDrawing().figures();
        while (fe.hasMoreElements()) {
            Rectangle r;
            Figure figure = fe.nextFigure();
            Figure selected = null;
            if (figure instanceof NodeFigure) {
                r = ((NodeFigure)figure).compactDisplayBox();
                if (this.selectRect.contains(r.x, r.y) && this.selectRect.contains(r.x + r.width, r.y + r.height)) {
                    selected = figure;
                }
            } else if (figure instanceof PolySplineConnection) {
                PolySplineConnection con = (PolySplineConnection)figure;
                if (this.selectRect.contains(con.startPoint()) && this.selectRect.contains(con.endPoint())) {
                    selected = figure;
                }
            } else if (figure instanceof TextElementFigure) {
                r = ((TextElementFigure)figure).displayBox();
                if (this.selectRect.contains(r.x, r.y) && this.selectRect.contains(r.x + r.width, r.y + r.height)) {
                    selected = figure;
                }
            }
            if (selected == null) continue;
            if (toggle) {
                this.getView().toggleSelection(selected);
                continue;
            }
            this.getView().addToSelection(selected);
        }
        this.getView().redraw();
    }
}

