/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.drawing.Trackable;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.cockpit.modeler.util.InputState;
import org.openbp.common.CommonUtil;

public class ScrollTool
extends ModelerTool {
    public ScrollTool(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        WorkspaceDrawingView view = this.getView();
        Point lastPoint = this.getLastPoint();
        int xDiff = CommonUtil.rnd((double)((double)(e.getX() - lastPoint.x) / 1.5));
        int yDiff = CommonUtil.rnd((double)((double)(e.getY() - lastPoint.y) / 1.5));
        xDiff = view.applyScale(xDiff, true);
        yDiff = view.applyScale(yDiff, true);
        if (xDiff != 0 || yDiff != 0) {
            ((Trackable)((Object)this.getEditor())).moveTrackerBy(xDiff, yDiff);
        }
    }

    @Override
    public void deactivate() {
        this.getView().revalidate();
        super.deactivate();
    }

    @Override
    public void keyDown(KeyEvent e, int key) {
        if (InputState.isCtrlDown()) {
            this.deactivate();
            this.getToolSupport().updateToolState(e);
        }
    }

    @Override
    public void keyUp(KeyEvent e, int key) {
        this.deactivate();
    }
}

