/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.association;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openbp.cockpit.plugins.association.MimeTypeAssociation;
import org.openbp.common.rc.ResourceCollection;

public class AssociationMimeTypesUtil {
    private static Map defaultAssociations = new LinkedHashMap();

    private AssociationMimeTypesUtil() {
    }

    static List addDefaultAssociations(List mimeTypes, ResourceCollection res) {
        if (mimeTypes == null) {
            mimeTypes = new ArrayList<MimeTypeAssociation>();
        }
        for (String type : defaultAssociations.keySet()) {
            boolean found = false;
            int n = mimeTypes.size();
            for (int i = 0; i < n; ++i) {
                MimeTypeAssociation mta = (MimeTypeAssociation)((Object)mimeTypes.get(i));
                String name = mta.getName();
                if (!name.equals(type)) continue;
                found = true;
                break;
            }
            if (found) continue;
            mimeTypes.add(AssociationMimeTypesUtil.createMimeType(type, res));
        }
        return mimeTypes;
    }

    private static MimeTypeAssociation createMimeType(String mimeType, ResourceCollection res) {
        MimeTypeAssociation mta = new MimeTypeAssociation(mimeType);
        if (mimeType == null) {
            return mta;
        }
        String defaultValue = (String)defaultAssociations.get(mimeType);
        mta.setDescription(res.getOptionalString("mimetype." + mimeType.replace('/', '.') + "description", defaultValue));
        return mta;
    }

    static {
        defaultAssociations.put("application/x-url", "External Web Browser");
        defaultAssociations.put("text/plain", "Text Editor");
        defaultAssociations.put("text/x-source", "Source Editor");
        defaultAssociations.put("text/html", "HTML Editor");
        defaultAssociations.put("text/xml", "XML/XSL Editor");
        defaultAssociations.put("application/pdf", "PDF Reader");
    }
}

