/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.association;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.openbp.cockpit.itemeditor.NodeItemEditorPlugin;
import org.openbp.common.CollectionUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionUtil;
import org.openbp.core.model.Association;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.Item;
import org.openbp.guiclient.event.FileOpenEvent;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.OpenEventInfo;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.RequestEvent;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.swing.components.JMsgBox;

public class AssociationPlugin
extends AbstractPlugin {
    private Map mimeTypesToOpenEventInfos = new Hashtable();
    private static final OpenEventInfo[] noOpenEvents = new OpenEventInfo[0];

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    private JaspiraEventHandlerCode doOpen(Association association, boolean readOnly, JaspiraEvent event) {
        String[] types = null;
        if (association != null) {
            types = association.getAssociationTypes();
        } else if (event instanceof OpenEvent) {
            types = ((OpenEvent)event).getMimeTypes();
        }
        if (types != null && types.length != 0) {
            OpenEventInfo[] openEventInfo;
            if (event instanceof OpenEvent && ((OpenEvent)event).isReadonly()) {
                readOnly = true;
            }
            if ((openEventInfo = this.determineOpenEvents(types, (Plugin)this)) != null) {
                Object object = null;
                Object underlyingObject = null;
                if (association != null) {
                    object = association.getAssociatedObject();
                    underlyingObject = association.getUnderlyingObject();
                } else {
                    object = event.getObject();
                }
                OpenEvent oe = null;
                String mimeType = openEventInfo[0].getMimeType();
                if (mimeType.startsWith("text/") && underlyingObject instanceof Item) {
                    FileOpenEvent foe = new FileOpenEvent((Plugin)this, openEventInfo[0].getEventName(), (String)object, new String[]{openEventInfo[0].getMimeType()});
                    foe.setUnderlyingObject(underlyingObject);
                    foe.setReadonly(readOnly);
                    foe.setCreate(true);
                    if (event instanceof FileOpenEvent) {
                        foe.setColumnNumber(((FileOpenEvent)event).getColumnNumber());
                        foe.setLineNumber(((FileOpenEvent)event).getLineNumber());
                    }
                    oe = foe;
                } else {
                    oe = new OpenEvent(this, openEventInfo[0].getEventName(), object);
                    oe.setUnderlyingObject(underlyingObject);
                    oe.setReadonly(readOnly);
                    oe.setCreate(true);
                    oe.setMimeTypes(new String[]{openEventInfo[0].getMimeType()});
                }
                if (this.fireEvent(oe)) {
                    return EventModule.EVENT_HANDLED;
                }
            }
        }
        return EventModule.EVENT_IGNORED;
    }

    OpenEventInfo[] determineOpenEvents(String[] mimeTypes, Plugin sourcePlugin) {
        if (mimeTypes != null) {
            for (int i = 0; i < mimeTypes.length; ++i) {
                OpenEventInfo[] ois = this.determineOpenEvents(mimeTypes[i], sourcePlugin);
                if (ois == null) continue;
                return ois;
            }
        }
        return null;
    }

    OpenEventInfo[] determineOpenEvents(String mimeType, Plugin sourcePlugin) {
        OpenEventInfo[] ois = (OpenEventInfo[])this.mimeTypesToOpenEventInfos.get(mimeType);
        if (ois != null) {
            if (ois.length != 0) {
                return ois;
            }
            return null;
        }
        RequestEvent requestEvent = new RequestEvent(sourcePlugin, "plugin.association.supports", mimeType);
        sourcePlugin.fireEvent(requestEvent);
        List resultList = requestEvent.getResultList();
        if (resultList == null) {
            this.mimeTypesToOpenEventInfos.put(mimeType, noOpenEvents);
            return null;
        }
        ois = (OpenEventInfo[])CollectionUtil.toArray((Collection)resultList, OpenEventInfo.class);
        this.mimeTypesToOpenEventInfos.put(mimeType, ois);
        return ois;
    }

    public void clearCache() {
        this.mimeTypesToOpenEventInfos.clear();
    }

    private class OpenAction
    extends JaspiraAction {
        private Association association;
        private OpenEventInfo openEventInfo;
        private boolean readOnly;

        public OpenAction(Association association, OpenEventInfo openEventInfo, boolean readOnly) {
            super((DisplayObject)association);
            this.association = association;
            this.openEventInfo = openEventInfo;
            this.readOnly = readOnly;
            String s = openEventInfo.getDescription();
            if (s != null) {
                String d = this.getDisplayName();
                d = d != null ? d + " (" + s + ")" : s;
                this.setDisplayName(d);
                d = "Opens the object in the " + s;
                this.setDescription(d);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            OpenEvent oe = new OpenEvent(AssociationPlugin.this, this.openEventInfo.getEventName(), this.association.getAssociatedObject());
            oe.setUnderlyingObject(this.association.getUnderlyingObject());
            oe.setReadonly(this.readOnly);
            oe.setCreate(true);
            oe.setMimeTypes(new String[]{this.openEventInfo.getMimeType()});
            AssociationPlugin.this.fireEvent(oe);
        }
    }

    public class InteractionEvents
    extends InteractionModule {
        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public JaspiraEventHandlerCode popup(InteractionEvent ie) {
            if (!ie.isDataFlavorSupported(ClientFlavors.MODEL_OBJECT)) {
                return EVENT_IGNORED;
            }
            if (ie.getSourcePlugin() instanceof NodeItemEditorPlugin) {
                return EVENT_IGNORED;
            }
            ModelObject mo = (ModelObject)ie.getSafeTransferData(ClientFlavors.MODEL_OBJECT);
            List associations = mo.getAssociations();
            if (associations != null) {
                JaspiraAction group = new JaspiraAction(AssociationPlugin.this, "submenu.open");
                int n = associations.size();
                for (int iAssoc = 0; iAssoc < n; ++iAssoc) {
                    Association association = (Association)associations.get(iAssoc);
                    String hintMsg = null;
                    OpenEventInfo[] openEventInfo = null;
                    if (association.getAssociatedObject() == null) {
                        hintMsg = association.getHintMsg();
                    } else {
                        String[] types = association.getAssociationTypes();
                        if (types == null || types.length == 0) {
                            hintMsg = AssociationPlugin.this.getPluginResourceCollection().getRequiredString("messages.hints.noassociation");
                        } else {
                            openEventInfo = AssociationPlugin.this.determineOpenEvents(types, (Plugin)AssociationPlugin.this);
                            if (openEventInfo == null) {
                                hintMsg = AssociationPlugin.this.getPluginResourceCollection().getRequiredString("messages.hints.wrongassociation");
                            }
                        }
                    }
                    if (openEventInfo != null) {
                        for (int iEvent = 0; iEvent < openEventInfo.length; ++iEvent) {
                            OpenAction openAction = new OpenAction(association, openEventInfo[iEvent], !mo.isModifiable());
                            openAction.setPriority(iAssoc * 10 + iEvent);
                            group.addMenuChild(openAction);
                        }
                        continue;
                    }
                    JaspiraAction emptyAction = new JaspiraAction((DisplayObject)association);
                    emptyAction.setDescription(hintMsg);
                    emptyAction.setEnabled(false);
                    emptyAction.setPriority(iAssoc * 10);
                    group.addMenuChild(emptyAction);
                }
                ie.add(group);
            }
            return EVENT_HANDLED;
        }
    }

    public class AssociationEvents
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.association";
        }

        @Override
        public int getPriority() {
            return 2;
        }

        public JaspiraEventHandlerCode open(JaspiraEvent event) {
            return this.eventOpen(event, 1);
        }

        public JaspiraEventHandlerCode tryopen(JaspiraEvent event) {
            return this.eventTryOpen(event, 1);
        }

        public JaspiraEventHandlerCode update(JaspiraEvent je) {
            AssociationPlugin.this.clearCache();
            return EVENT_HANDLED;
        }

        /*
         * Unable to fully structure code
         */
        private JaspiraEventHandlerCode eventOpen(JaspiraEvent event, int priority) {
            ret = this.eventTryOpen(event, priority);
            if (ret == AssociationEvents.EVENT_IGNORED) {
                mimeTypes = null;
                o = event.getObject();
                if (o instanceof Transferable) {
                    transferable = (Transferable)event.getObject();
                    if (transferable.isDataFlavorSupported(ClientFlavors.MODEL_OBJECT)) {
                        try {
                            mo = (ModelObject)transferable.getTransferData(ClientFlavors.MODEL_OBJECT);
                            associations = mo.getAssociations();
                            if (associations == null) ** GOTO lbl29
                            n = associations.size();
                            for (i = 0; i < n; ++i) {
                                assoc = (Association)associations.get(i);
                                if (assoc.getAssociationPriority() != priority) continue;
                                mimeTypes = assoc.getAssociationTypes();
                            }
                        }
                        catch (IOException e) {
                            return AssociationEvents.EVENT_IGNORED;
                        }
                        catch (UnsupportedFlavorException e) {
                            return AssociationEvents.EVENT_IGNORED;
                        }
                    }
                } else if (o instanceof Association) {
                    mimeTypes = ((Association)o).getAssociationTypes();
                } else if (event instanceof OpenEvent) {
                    mimeTypes = ((OpenEvent)event).getMimeTypes();
                }
lbl29:
                // 8 sources

                mimeTypeStr = "?\n";
                if (mimeTypes != null) {
                    sb = new StringBuffer();
                    for (i = 0; i < mimeTypes.length; ++i) {
                        sb.append(mimeTypes[i]);
                        sb.append("\n");
                    }
                    mimeTypeStr = sb.toString();
                }
                msg = ResourceCollectionUtil.formatMsg((ResourceCollection)AssociationPlugin.this.getPluginResourceCollection(), (String)"messages.noassociation", (Object[])new Object[]{mimeTypeStr});
                JMsgBox.show(null, (String)msg, (int)262144);
            }
            return ret;
        }

        private JaspiraEventHandlerCode eventTryOpen(JaspiraEvent event, int priority) {
            JaspiraEventHandlerCode ret;
            Association assoc;
            Object o = event.getObject();
            if (event instanceof OpenEvent) {
                JaspiraEventHandlerCode ret2 = AssociationPlugin.this.doOpen(null, false, event);
                if (ret2 != EventModule.EVENT_IGNORED) {
                    return ret2;
                }
            } else if (o instanceof Transferable) {
                Transferable transferable = (Transferable)o;
                if (transferable.isDataFlavorSupported(ClientFlavors.MODEL_OBJECT)) {
                    List associations;
                    ModelObject mo = null;
                    try {
                        mo = (ModelObject)transferable.getTransferData(ClientFlavors.MODEL_OBJECT);
                    }
                    catch (IOException e) {
                        return EVENT_IGNORED;
                    }
                    catch (UnsupportedFlavorException e) {
                        return EVENT_IGNORED;
                    }
                    if (mo != null && (associations = mo.getAssociations()) != null) {
                        int n = associations.size();
                        for (int i = 0; i < n; ++i) {
                            JaspiraEventHandlerCode ret3;
                            Association assoc2 = (Association)associations.get(i);
                            if (assoc2.getAssociationPriority() != priority || (ret3 = AssociationPlugin.this.doOpen(assoc2, !mo.isModifiable(), event)) == EventModule.EVENT_IGNORED) continue;
                            return ret3;
                        }
                    }
                }
            } else if (o instanceof Association && (assoc = (Association)o).getAssociationPriority() == 1 && (ret = AssociationPlugin.this.doOpen(assoc, false, event)) != EventModule.EVENT_IGNORED) {
                return ret;
            }
            return EVENT_IGNORED;
        }
    }
}

