/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.debugger;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openbp.cockpit.plugins.debugger.DebuggerServerEvent;
import org.openbp.common.MsgFormat;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.core.OpenBPException;
import org.openbp.core.engine.debugger.CallStackInfo;
import org.openbp.core.engine.debugger.DebuggerService;
import org.openbp.core.model.ModelQualifier;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.QualifierEvent;
import org.openbp.guiclient.remote.ServerConnection;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.Plugin;

public class StackTracePlugin
extends AbstractVisiblePlugin {
    private String debuggerId;
    private ModelQualifier currentPos;
    private StackTraceTableModel tableModel;
    private JTable table;
    private static Vector tableHeaders;
    private static String titleStatus;
    private boolean debuggerListening;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.debugger";
    }

    @Override
    protected void initializeComponents() {
        if (tableHeaders == null) {
            ResourceCollection res = this.getPluginResourceCollection();
            tableHeaders = new Vector();
            tableHeaders.add(res.getRequiredString("header.column1"));
            tableHeaders.add(res.getRequiredString("header.column2"));
            titleStatus = res.getRequiredString("titlestatus");
        }
        this.tableModel = new StackTraceTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(20);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point p = e.getPoint();
                    int row = StackTracePlugin.this.table.rowAtPoint(p);
                    String pos = (String)StackTracePlugin.this.tableModel.getValueAt(row, 1);
                    if (pos == null) {
                        return;
                    }
                    ModelQualifier qualifier = new ModelQualifier(pos);
                    qualifier.setItemType("Process");
                    ModelQualifier processQualifier = new ModelQualifier(qualifier);
                    processQualifier.setObjectPath(null);
                    StackTracePlugin.this.fireEvent(new OpenEvent(StackTracePlugin.this, "open.modeler", processQualifier));
                    QualifierEvent event = new QualifierEvent((Plugin)StackTracePlugin.this, "modeler.view.select", qualifier);
                    StackTracePlugin.this.fireEvent(event);
                    StackTracePlugin.this.fireEvent(event);
                }
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.table), "Center");
    }

    protected void refresh() {
        DebuggerService debuggerService = (DebuggerService)ServerConnection.getInstance().lookupOptionalService(DebuggerService.class);
        if (debuggerService == null) {
            return;
        }
        this.determineDebuggerId();
        ArrayList callStackElements = null;
        try {
            callStackElements = debuggerService.getCallStackElements(this.debuggerId);
        }
        catch (OpenBPException openBPException) {
            // empty catch block
        }
        if (callStackElements == null) {
            callStackElements = new ArrayList();
        }
        this.tableModel.setCallStackElements(callStackElements);
    }

    protected void determineDebuggerId() {
        if (this.debuggerId == null) {
            AskEvent ae = new AskEvent(this, "debugger.client.getdebuggerid");
            this.fireEvent(ae);
            this.debuggerId = (String)ae.getAnswer();
            if (this.debuggerId == null) {
                System.err.println("Debugger id could not be requested from debugger plugin");
                return;
            }
        }
    }

    @Override
    public String getTitle() {
        if (!this.debuggerListening) {
            return super.getTitle();
        }
        this.determineDebuggerId();
        return super.getTitle() + " " + MsgFormat.format((String)titleStatus, (Object)this.debuggerId);
    }

    @Override
    public String getSubTitle() {
        return super.getTitle();
    }

    public class StackTraceTableModel
    extends DefaultTableModel {
        public void setCallStackElements(List callStackElements) {
            Vector rows = new Vector();
            if (callStackElements != null) {
                Vector<Object> row;
                for (CallStackInfo callStackInfo : callStackElements) {
                    row = new Vector();
                    row.add(callStackInfo.getSavedPosition());
                    rows.add(0, row);
                }
                row = new Vector<Object>();
                row.add(StackTracePlugin.this.currentPos.toString());
                rows.add(0, row);
            }
            this.setDataVector(rows, tableHeaders);
            TableColumnModel columnModel = StackTracePlugin.this.table.getColumnModel();
            try {
                TableColumn column = columnModel.getColumn(0);
                if (column != null) {
                    column.setPreferredWidth(100);
                    column.setMaxWidth(100);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }
    }

    public class ServerEvents
    extends EventModule {
        @Override
        public String getName() {
            return "debugger.server";
        }

        public JaspiraEventHandlerCode nodeentry(DebuggerServerEvent dse) {
            StackTracePlugin.this.currentPos = dse.getHaltedPosition();
            StackTracePlugin.this.refresh();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode nodeexit(DebuggerServerEvent dse) {
            StackTracePlugin.this.currentPos = dse.getHaltedPosition();
            StackTracePlugin.this.refresh();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode debugger_client_clearstatuswindows(JaspiraEvent je) {
            StackTracePlugin.this.tableModel.setCallStackElements(null);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode debugger_client_statuschange(JaspiraEvent je) {
            String clientId = (String)je.getObject();
            StackTracePlugin.this.debuggerListening = clientId != null;
            StackTracePlugin.this.postPluginContainerUpdate(false);
            StackTracePlugin.this.tableModel.setCallStackElements(null);
            return EVENT_HANDLED;
        }
    }
}

