/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.finder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openbp.cockpit.plugins.finder.DisplayMapper;
import org.openbp.cockpit.plugins.finder.ModelObjectMapper;
import org.openbp.cockpit.plugins.finder.RefComparator;
import org.openbp.cockpit.plugins.finder.StringMapper;
import org.openbp.cockpit.plugins.finder.treemodel.DataMapper;
import org.openbp.cockpit.plugins.finder.treemodel.LeafNode;
import org.openbp.cockpit.plugins.finder.treemodel.NodeMapper;
import org.openbp.cockpit.plugins.finder.treemodel.PropertyNode;
import org.openbp.cockpit.plugins.finder.treemodel.Strategy;
import org.openbp.core.OpenBPException;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.guiclient.model.ModelConnector;

public class RefStrategy
implements Strategy {
    public static final String ITEMTYPE_KEY = "itemtype";
    public static final String REFERENCE_ITEMTYPE_KEY = "referenceItemType";
    public static final String PRIORITY_KEY = "priority";
    static NodeMapper stringMapper = new StringMapper();
    static NodeMapper displayMapper = new DisplayMapper();
    static NodeMapper coreMapper = new ModelObjectMapper();
    static Comparator refComp = new RefComparator();
    String referenceItemType;

    public void setReferenceItemType(String itemType) {
        this.referenceItemType = itemType;
    }

    @Override
    public DataMapper createDataMapper(Object leafData) {
        RefMapper mapper = new RefMapper();
        mapper.init(leafData);
        return mapper;
    }

    @Override
    public Comparator getTreeComparator() {
        return refComp;
    }

    class RefMapper
    implements DataMapper {
        private List list = new ArrayList();
        private ModelObject leafObject;

        RefMapper() {
        }

        @Override
        public void init(Object leafObj) {
            this.leafObject = (ModelObject)leafObj;
            ModelQualifier qualifier = this.leafObject.getQualifier();
            PropertyNode modelNode = new PropertyNode();
            ModelQualifier modelQualifier = ModelQualifier.constructModelQualifier((String)qualifier.getModel());
            try {
                Model model = ModelConnector.getInstance().getModelByQualifier(modelQualifier);
                modelNode.setNodeMapper(displayMapper);
                modelNode.setPropertyData(model);
            }
            catch (OpenBPException e) {
                modelNode.setNodeMapper(stringMapper);
                modelNode.setPropertyData(modelQualifier.toString());
            }
            modelNode.addProperty(RefStrategy.ITEMTYPE_KEY, "Model");
            modelNode.addProperty(RefStrategy.PRIORITY_KEY, new Integer(1));
            this.list.add(modelNode);
            if (qualifier.getObjectPath() != null) {
                PropertyNode objectPathNode = new PropertyNode();
                try {
                    Item item = ModelConnector.getInstance().getItemByQualifier(qualifier, true);
                    objectPathNode.setNodeMapper(displayMapper);
                    objectPathNode.setPropertyData(item);
                }
                catch (OpenBPException e) {
                    objectPathNode.setNodeMapper(stringMapper);
                    objectPathNode.setPropertyData(qualifier.getItem());
                }
                objectPathNode.addProperty(RefStrategy.ITEMTYPE_KEY, qualifier.getItemType());
                objectPathNode.addProperty(RefStrategy.PRIORITY_KEY, new Integer(2));
                this.list.add(objectPathNode);
            }
        }

        @Override
        public LeafNode createLeafNode() {
            LeafNode node = new LeafNode();
            node.setNodeMapper(coreMapper);
            node.setLeafData(this.leafObject);
            node.addProperty(RefStrategy.PRIORITY_KEY, new Integer(3));
            node.addProperty(RefStrategy.REFERENCE_ITEMTYPE_KEY, RefStrategy.this.referenceItemType);
            ModelQualifier qualifier = this.leafObject.getQualifier();
            if (qualifier.getObjectPath() == null) {
                node.addProperty(RefStrategy.ITEMTYPE_KEY, qualifier.getItemType());
            }
            return node;
        }

        @Override
        public PropertyNode createPropertyNode(int level) {
            return (PropertyNode)((Object)this.list.get(level));
        }

        @Override
        public int getLevels() {
            return this.list.size();
        }
    }
}

