/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.finder.treemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.openbp.cockpit.plugins.finder.treemodel.DataMapper;
import org.openbp.cockpit.plugins.finder.treemodel.GenericNode;
import org.openbp.cockpit.plugins.finder.treemodel.LeafNode;
import org.openbp.cockpit.plugins.finder.treemodel.NodeMapper;
import org.openbp.cockpit.plugins.finder.treemodel.PropertyNode;
import org.openbp.cockpit.plugins.finder.treemodel.Strategy;

public class GenericModel
extends DefaultTreeModel {
    private List addedNodes;
    private List removedNodes;
    private Map dataInformation;
    private Strategy strategy;
    private boolean fireEvents;

    public GenericModel(Strategy usedStrategy, boolean fireEvents) {
        super((TreeNode)((Object)new PropertyNode()));
        this.getRootNode().setNodeMapper(new RootNodeMapper());
        this.strategy = usedStrategy;
        this.fireEvents = fireEvents;
        this.addedNodes = new ArrayList();
        this.removedNodes = new ArrayList();
    }

    private PropertyNode getRootNode() {
        return (PropertyNode)((Object)this.root);
    }

    public Iterator addNewData(Object data) {
        this.addedNodes.clear();
        this.removedNodes.clear();
        this.addDataToNodes(data, this.strategy.createDataMapper(data), this.getRootNode(), 0);
        return this.addedNodes.iterator();
    }

    private void addDataToNodes(Object data, DataMapper mapper, GenericNode parentNode, int level) {
        if (level == mapper.getLevels()) {
            LeafNode leaf = mapper.createLeafNode();
            parentNode.addChild(leaf, this.strategy);
            if (this.fireEvents) {
                this.nodesWereInserted((TreeNode)((Object)parentNode), new int[]{parentNode.getIndex((TreeNode)((Object)leaf))});
            }
            return;
        }
        PropertyNode group = mapper.createPropertyNode(level);
        PropertyNode existingGroup = parentNode.getPropertyNode(group.getPropertyData());
        if (existingGroup == null) {
            existingGroup = group;
            parentNode.addChild(group, this.strategy);
            existingGroup.setLevel(level);
            if (this.fireEvents) {
                this.nodesWereInserted((TreeNode)((Object)parentNode), new int[]{parentNode.getIndex((TreeNode)((Object)group))});
            }
        }
        this.addDataToNodes(data, mapper, existingGroup, level + 1);
    }

    public void reload(Object[] data) {
        this.clearModel();
        for (int i = 0; i < data.length; ++i) {
            this.addNewData(data[i]);
        }
        if (this.fireEvents) {
            this.nodeStructureChanged(this.root);
        }
    }

    public void reload(Iterator iterator) {
        this.clearModel();
        while (iterator.hasNext()) {
            this.addNewData(iterator.next());
        }
        if (this.fireEvents) {
            this.nodeStructureChanged(this.root);
        }
    }

    public void clearModel() {
        this.dataInformation = new HashMap();
        this.clearNode(this.getRootNode());
        this.getRootNode().clearChilds();
        if (this.fireEvents) {
            this.nodeStructureChanged(this.root);
        }
    }

    private void clearNode(GenericNode node) {
        if (node.isLeaf()) {
            node.nodeData = null;
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            GenericNode genericNode = (GenericNode)((Object)node.getChildAt(i));
            this.clearNode(genericNode);
            genericNode.clearChilds();
        }
    }

    public Iterator removeData(Object data) {
        Information info = (Information)this.dataInformation.get(data);
        return this.removeNode(info.node);
    }

    public Iterator removeNode(GenericNode node) {
        this.addedNodes.clear();
        this.removedNodes.clear();
        this.removeNodeFromTree(node);
        return this.removedNodes.iterator();
    }

    private void removeNodeFromTree(GenericNode node) {
        GenericNode parentNode = (GenericNode)((Object)node.getParent());
        int index = parentNode.getIndex((TreeNode)((Object)node));
        parentNode.removeChild(node);
        this.removedNodes.add(node);
        if (this.fireEvents) {
            this.nodesWereRemoved((TreeNode)((Object)parentNode), new int[]{index}, new Object[]{node});
        }
        if (parentNode.getParent() == null) {
            return;
        }
        if (parentNode.isLeaf()) {
            this.removeNodeFromTree(parentNode);
        }
    }

    public boolean containsDataObject(Object data) {
        return this.dataInformation.get(data) != null;
    }

    public Iterator getDataObjects() {
        return this.dataInformation.keySet().iterator();
    }

    class RootNodeMapper
    implements NodeMapper {
        RootNodeMapper() {
        }

        @Override
        public String getDisplayString(Object nodeData) {
            return "root";
        }
    }

    class Information {
        LeafNode node;
        Object data;

        protected Information(Object data) {
            this.data = data;
        }
    }
}

