/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.miniview;

import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.StandardDrawingView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.plugins.miniview.MiniViewPlugin;
import org.openbp.cockpit.plugins.miniview.MiniViewZoomTool;

public class MiniView
extends StandardDrawingView
implements ChangeListener {
    private double scale = 0.2;
    private Tool miniViewTool;
    private Rectangle trackRect;
    private MiniViewPlugin parent;
    private Modeler modeler;
    private static final Dimension MIN_DIM = new Dimension(50, 50);

    public MiniView(Modeler modeler, MiniViewPlugin parent) {
        super((DrawingEditor)modeler);
        this.modeler = modeler;
        this.parent = parent;
        this.miniViewTool = new MiniViewZoomTool(this);
        this.setBackground(ModelerColors.MINIVIEW);
    }

    public void unregister() {
        this.setEditor(null);
        this.drawing().removeDrawingChangeListener((DrawingChangeListener)this);
        this.parent = null;
        this.modeler = null;
        this.miniViewTool.deactivate();
        this.miniViewTool = null;
    }

    public void redraw() {
        this.repaint();
    }

    public void drawAll(Graphics g) {
        this.revalidateScale();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBackground(g2);
        g2.scale(this.scale, this.scale);
        this.drawDrawing(g2);
        this.drawViews(g2);
        this.drawTrack(g2);
        g2.scale(1.0 / this.scale, 1.0 / this.scale);
    }

    protected void drawViews(Graphics g) {
        g.setColor(ModelerColors.MINIVIEW_TRACKER);
        Rectangle r = this.modeler.getVisibleArea();
        g.fillRect(r.x, r.y, r.width, r.height);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    protected void drawTrack(Graphics g) {
        if (this.trackRect != null) {
            g.setColor(Color.GRAY);
            g.drawRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
        }
    }

    public void repaint(int x, int y, int w, int h) {
        super.repaint();
    }

    private void revalidateScale() {
        this.revalidate();
        Dimension rectDim = this.getParent().getParent().getSize();
        rectDim.width /= this.parent.getNumberOfMiniViews();
        Rectangle drawingRect = ((ProcessDrawing)this.drawing()).displayBox();
        int drawingWidth = (int)drawingRect.getMaxX();
        int drawingHeight = (int)drawingRect.getMaxY();
        drawingHeight = Math.max(drawingHeight, 500);
        drawingWidth = Math.max(drawingWidth, 500);
        Insets insets = this.getParent().getParent().getInsets();
        this.scale = Math.min((double)(rectDim.width - insets.left - insets.right - 5) / (double)drawingWidth, (double)(rectDim.height - insets.top - insets.bottom - 5) / (double)drawingHeight);
    }

    public double getScale() {
        this.revalidateScale();
        return this.scale;
    }

    public void setTrackRect(Rectangle r) {
        this.trackRect = r;
        this.redraw();
    }

    public Modeler getModeler() {
        return this.modeler;
    }

    public Dimension getMinimumSize() {
        return MIN_DIM;
    }

    public Tool tool() {
        return this.miniViewTool;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.redraw();
    }
}

