/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.miniview;

import CH.ifa.draw.framework.Drawing;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.border.Border;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.plugins.miniview.MiniView;
import org.openbp.cockpit.plugins.miniview.MiniViewEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.option.IntegerOption;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.OptionModule;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class MiniViewPlugin
extends AbstractVisiblePlugin {
    private int maxMiniViews = 2;
    private Box content;
    private LinkedList miniViews;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    @Override
    protected void initializeComponents() {
        this.miniViews = new LinkedList();
        this.content = Box.createHorizontalBox();
        this.content.setOpaque(false);
        int max = OptionMgr.getInstance().getIntegerOption("modeler.miniview.numberoption", this.maxMiniViews);
        this.setMaximumDisplayedViews(max);
        MiniViewEvent event = new MiniViewEvent(this, "miniview.created");
        this.fireEvent(event);
        Iterator it = event.getEditors().iterator();
        while (it.hasNext()) {
            this.addModeler((Modeler)it.next());
        }
        this.getContentPane().add(this.content);
    }

    protected void setMaximumDisplayedViews(int number) {
        this.maxMiniViews = number;
        int count = 0;
        Iterator it = this.miniViews.iterator();
        while (it.hasNext()) {
            MiniView view = (MiniView)it.next();
            if (++count < this.maxMiniViews) continue;
            it.remove();
            this.content.remove((Component)((Object)view));
        }
        this.getContentPane().revalidate();
    }

    protected void addModeler(Modeler modeler) {
        Iterator it = this.miniViews.iterator();
        while (it.hasNext()) {
            MiniView view = (MiniView)it.next();
            if (view.getModeler() != modeler) continue;
            it.remove();
            this.miniViews.addFirst(view);
            return;
        }
        int count = 0;
        Iterator it2 = this.miniViews.iterator();
        while (it2.hasNext()) {
            MiniView view = (MiniView)it2.next();
            if (++count < this.maxMiniViews) continue;
            it2.remove();
            this.content.remove((Component)((Object)view));
        }
        MiniView miniView = new MiniView(modeler, this);
        miniView.setDrawing((Drawing)modeler.getDrawing());
        modeler.addTrackChangedListener(miniView);
        this.content.add((Component)((Object)miniView));
        this.miniViews.addFirst(miniView);
        this.updateMiniViewBorders();
    }

    protected void removeModeler(Modeler modeler) {
        Iterator it = this.miniViews.iterator();
        while (it.hasNext()) {
            MiniView miniView = (MiniView)it.next();
            if (miniView.editor() != modeler) continue;
            modeler.removeTrackChangedListener(miniView);
            miniView.unregister();
            it.remove();
            this.content.remove((Component)((Object)miniView));
            break;
        }
        this.updateMiniViewBorders();
        this.getPluginComponent().repaint();
    }

    public int getNumberOfMiniViews() {
        return this.miniViews.size();
    }

    private void updateMiniViewBorders() {
        Iterator it = this.miniViews.iterator();
        while (it.hasNext()) {
            MiniView view = (MiniView)it.next();
            if (it.hasNext()) {
                view.setBorder((Border)new SimpleBorder(0, 1, 0, 0));
                continue;
            }
            view.setBorder(null);
        }
    }

    public class MiniViewOptionModule
    extends OptionModule {

        public class NumberOption
        extends IntegerOption {
            public NumberOption() {
                super(MiniViewPlugin.this.getPluginResourceCollection(), "modeler.miniview.numberoption", new Integer(2), 1, 5);
            }
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "miniview";
        }

        public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                MiniViewPlugin.this.addModeler((Modeler)o);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_closed(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                MiniViewPlugin.this.removeModeler((Modeler)o);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_miniview_numberoption(JaspiraEvent je) {
            Option opt = (Option)je.getObject();
            if (opt instanceof MiniViewOptionModule.NumberOption) {
                MiniViewPlugin.this.setMaximumDisplayedViews((Integer)opt.getValue());
            }
            return EVENT_HANDLED;
        }
    }
}

