/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.miniview;

import CH.ifa.draw.standard.AbstractTool;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.plugins.miniview.MiniView;

public class MiniViewZoomTool
extends AbstractTool {
    private MiniView miniView;
    private int lastX;
    private int lastY;
    private boolean tracking;

    public MiniViewZoomTool(MiniView miniView) {
        super(miniView.editor());
        this.miniView = miniView;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.lastX = x;
        this.lastY = y;
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        Modeler modeler = this.miniView.getModeler();
        if (modeler != null) {
            if (e.getClickCount() == 2) {
                modeler.setScaleFactor(1.0);
                modeler.centerTrackerAt(this.calculateDocumentCoordinates(e.getPoint()));
            } else if (this.tracking) {
                this.miniView.setTrackRect(null);
                int rx = x < this.lastX ? x : this.lastX;
                int ry = y < this.lastY ? y : this.lastY;
                int w = x < this.lastX ? this.lastX - x : x - this.lastX;
                int h = y < this.lastX ? this.lastY - y : y - this.lastY;
                Rectangle r = new Rectangle(rx, ry, w, h);
                modeler.setVisibleArea(this.calculateDocumentCoordinates(r));
            } else {
                modeler.centerTrackerAt(this.calculateDocumentCoordinates(e.getPoint()));
            }
        }
        this.tracking = false;
        DrawingEditorPlugin editor = (DrawingEditorPlugin)this.miniView.editor();
        editor.focusPlugin();
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        Rectangle r = new Rectangle(this.lastX, this.lastY, x - this.lastX, y - this.lastY);
        if (r.width >= 4 || r.width <= -4 || r.height >= 4 || r.height <= -4) {
            this.miniView.setTrackRect(this.calculateDocumentCoordinates(r));
            this.tracking = true;
        }
    }

    private Point calculateDocumentCoordinates(Point p) {
        double scale = this.miniView.getScale();
        p.x = (int)((double)p.x / scale);
        p.y = (int)((double)p.y / scale);
        return p;
    }

    private Rectangle calculateDocumentCoordinates(Rectangle r) {
        if (r.width < 0) {
            r.x += r.width;
            r.width *= -1;
        }
        if (r.height < 0) {
            r.y += r.height;
            r.height *= -1;
        }
        double scale = this.miniView.getScale();
        r.x = (int)((double)r.x / scale);
        r.y = (int)((double)r.y / scale);
        r.width = (int)((double)r.width / scale);
        r.height = (int)((double)r.height / scale);
        return r;
    }
}

