/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.variables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.util.CopyUtil;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.core.CoreConstants;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.core.model.item.process.ProcessVariableImpl;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.model.ModelConnector;

public class VariablesContainer
extends DisplayObjectImpl {
    private List processVariableList;
    private ProcessItem process;

    public VariablesContainer() {
        this.setName("ProcessVariables");
        this.setDescription("Process variables");
    }

    public VariablesContainer(ProcessItem process, List processVariableList) {
        this();
        this.process = process;
        this.processVariableList = processVariableList;
    }

    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        VariablesContainer src = (VariablesContainer)((Object)source);
        this.process = src.process;
        if (copyMode == 1 || copyMode == 2) {
            this.processVariableList = (List)CopyUtil.copyCollection((Collection)src.processVariableList, (int)(copyMode == 2 ? 2 : 0));
        }
    }

    public Iterator getProcessVariables() {
        if (this.processVariableList == null) {
            return EmptyIterator.getInstance();
        }
        return this.processVariableList.iterator();
    }

    public ProcessVariable createProcessVariableListElement() {
        ProcessVariableImpl param = new ProcessVariableImpl();
        String name = NamedObjectCollectionUtil.createUniqueId((Collection)this.processVariableList, (String)"ProcessVariable");
        param.setName(name);
        param.setProcess(this.process);
        try {
            DataTypeItem type = (DataTypeItem)ModelConnector.getInstance().getModelByQualifier(CoreConstants.SYSTEM_MODEL_QUALIFIER).getItem("Object", "Type", false);
            param.setDataType(type);
            param.setTypeName("Object");
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return param;
    }

    public void addProcessVariable(ProcessVariable processVariable) {
        if (this.processVariableList == null) {
            this.processVariableList = new ArrayList();
        }
        this.processVariableList.add(processVariable);
        processVariable.setProcess(this.process);
    }

    public void clearProcessVariables() {
        this.processVariableList = null;
    }

    public List getProcessVariableList() {
        return this.processVariableList;
    }

    public void setProcessVariableList(List processVariableList) {
        this.processVariableList = processVariableList;
    }

    public ProcessItem getProcess() {
        return this.process;
    }
}

