/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.template.standard;

import java.util.HashMap;
import java.util.List;
import org.openbp.cockpit.template.standard.JavaSrcTemplate;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.string.NameUtil;
import org.openbp.common.template.writer.JavaTemplateWriter;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelLocationUtil;
import org.openbp.core.model.item.activity.ActivityParam;
import org.openbp.core.model.item.activity.ActivitySocket;
import org.openbp.core.model.item.activity.JavaActivityItem;
import org.openbp.core.model.item.activity.StandardSocketNames;
import org.openbp.core.model.item.type.DataTypeItem;

public class ActivitySrcTemplate
extends JavaSrcTemplate {
    protected JavaActivityItem activity;
    protected StringBuffer inputComment;
    protected StringBuffer outputComment;
    protected List inputParamAccess;
    protected List outputParamAccess;
    protected String standardExitSocket;

    public void generate(Object[] templateArgs) throws Exception {
        this.activity = (JavaActivityItem)this.getProperty("item");
        String className = this.activity.getHandlerDefinition().getHandlerClassName();
        String dirName = ModelLocationUtil.expandModelLocation((Model)this.activity.getModel(), (String)"src");
        if (dirName == null) {
            throw new RuntimeException("Empty 'src' directory specified in tagged values of model, unable to generate code.");
        }
        JavaTemplateWriter writer = new JavaTemplateWriter(dirName, className);
        this.printFile(writer);
        writer.close();
        this.addResultFileInfo(writer.getFileName(), "text/x-java");
    }

    protected void printFile(JavaTemplateWriter w) throws Exception {
        this.inputComment = new StringBuffer();
        this.outputComment = new StringBuffer();
        this.printFileHeader(w);
        w.definePlaceholder("socketConstants", 0);
        w.definePlaceholder("paramConstants", 0);
        w.definePlaceholder("inputParamAccess", 0);
        w.definePlaceholder("outputParamAccess", 0);
        w.addImport("org.openbp.server.handler.Handler");
        w.addImport("org.openbp.server.handler.HandlerContext");
        List socketList = this.activity.getSocketList();
        this.prepareSocketInfo(w, socketList);
        if (!w.isPlaceholderEmpty("inputParamAccess")) {
            w.addToPlaceholder("inputParamAccess", "*/");
            w.addToPlaceholder("inputParamAccess", "");
        }
        if (!w.isPlaceholderEmpty("outputParamAccess")) {
            w.addToPlaceholder("outputParamAccess", "*/");
            w.addToPlaceholder("outputParamAccess", "");
        }
        this.printClassComment(w);
        this.printClassCode(w);
    }

    protected void printClassComment(JavaTemplateWriter w) throws Exception {
        String comment = this.createComment((DisplayObject)this.activity, "Implementation of the " + this.activity.getName() + " activity handler.");
        if (this.inputComment.length() != 0) {
            comment = comment + "\nInput sockets/parameter:\n";
            comment = comment + this.inputComment.toString();
        }
        if (this.outputComment.length() != 0) {
            comment = comment + "\nOutput sockets/parameter:\n";
            comment = comment + this.outputComment.toString();
        }
        w.printComment(comment, 2);
    }

    protected void printClassCode(JavaTemplateWriter w) throws Exception {
        w.println((Object)("public class " + w.getClassName()));
        w.addIndent(1);
        w.println((Object)"// {{*Custom extends*");
        w.println((Object)"// }}*Custom extends*");
        w.println((Object)"// {{*Custom interfaces*");
        w.println((Object)"implements Handler");
        w.println((Object)"// }}*Custom interfaces*");
        w.addIndent(-1);
        w.println((Object)"{");
        w.println((Object)"@[socketConstants]@");
        w.println((Object)"@[paramConstants]@");
        w.println((Object)"// {{*Custom constants*");
        w.println((Object)"// }}*Custom constants*");
        w.println();
        w.println((Object)"// {{*Custom members*");
        w.println((Object)"// Note: If you define member variables, consider the fact that the same handler instance may be executed");
        w.println((Object)"// by multiple threads in parallel, so you have to make sure that your implementation is thread safe.");
        w.println((Object)"// In general, member variables should be defined for global-like data only.");
        w.println((Object)"// }}*Custom members*");
        w.println();
        w.println((Object)"/**");
        w.println((Object)"* Executes the handler.");
        w.println((Object)"*");
        w.println((Object)"* @param hc Handler context that contains execution parameters");
        w.println((Object)"* @return true if the handler handled the event, false to apply the default handling to the event");
        w.println((Object)"* @throws Exception Any exception that may occur during execution of the handler will be");
        w.println((Object)"* propagated to an exception handler if defined or abort the process execution otherwise.");
        w.println((Object)"*/");
        w.println((Object)"public boolean execute(HandlerContext hc)");
        w.addIndent(1);
        w.println((Object)"throws Exception");
        w.addIndent(-1);
        w.println((Object)"{");
        w.println((Object)"@[inputParamAccess]@");
        w.println((Object)"@[outputParamAccess]@");
        this.printImplemenationCodeOutsideTag(w);
        w.println((Object)"// {{*Handler implementation*");
        this.printImplemenationCodeInsideTag(w);
        w.println((Object)"// }}*Handler implementation*");
        w.println((Object)"}");
        w.println();
        w.println((Object)"// {{*Custom methods*");
        w.println((Object)"// }}*Custom methods*");
        w.println((Object)"}");
    }

    protected void printImplemenationCodeOutsideTag(JavaTemplateWriter w) throws Exception {
    }

    protected void printImplemenationCodeInsideTag(JavaTemplateWriter w) throws Exception {
        w.println((Object)"return true;");
    }

    protected void prepareSocketInfo(JavaTemplateWriter w, List socketList) {
        if (socketList != null) {
            HashMap<String, Boolean> definedParams = new HashMap<String, Boolean>();
            int n = socketList.size();
            for (int i = 0; i < n; ++i) {
                ActivitySocket socket = (ActivitySocket)socketList.get(i);
                StringBuffer cm = socket.isEntrySocket() ? this.inputComment : this.outputComment;
                String socketName = socket.getName();
                String socketIdent = StandardSocketNames.getStandardSocketNameIdentifier((String)socketName);
                if (socketIdent == null) {
                    socketIdent = this.makeSocketName(socketName);
                    String type = socket.isEntrySocket() ? "Input" : "Output";
                    w.addToPlaceholder("socketConstants", "/** " + type + " socket " + socketName + " */");
                    w.addToPlaceholder("socketConstants", "private static final String " + socketIdent + " = \"" + socketName + "\";");
                    w.addToPlaceholder("socketConstants", "");
                }
                if (!socket.isEntrySocket() && socket.isDefaultSocket()) {
                    this.standardExitSocket = socketIdent;
                }
                cm.append("  Socket '");
                cm.append(socketName);
                cm.append("'");
                String dn = socket.getDisplayName();
                if (dn != null) {
                    cm.append(": ");
                    cm.append(dn);
                }
                cm.append("\n");
                List paramList = socket.getParamList();
                if (paramList == null) continue;
                int np = paramList.size();
                for (int ip = 0; ip < np; ++ip) {
                    ActivityParam param = (ActivityParam)paramList.get(ip);
                    String paramName = param.getName();
                    String paramIdent = this.makeParamName(paramName);
                    if (!definedParams.containsKey(paramName)) {
                        definedParams.put(paramName, Boolean.TRUE);
                        w.addToPlaceholder("paramConstants", "/** Parameter " + paramName + " */");
                        w.addToPlaceholder("paramConstants", "private static final String " + paramIdent + " = \"" + paramName + "\";");
                        w.addToPlaceholder("paramConstants", "");
                    }
                    cm.append("    Parameter '");
                    cm.append(paramName);
                    cm.append("'");
                    dn = param.getDisplayName();
                    if (dn != null) {
                        cm.append(": ");
                        cm.append(dn);
                    }
                    cm.append("\n");
                    DataTypeItem type = param.getDataType();
                    if (type == null) continue;
                    String className = type.getClassName();
                    if (className == null) {
                        className = "Object";
                    }
                    String typeName = this.extractUnqualifiedName(w, className);
                    String paramVariableName = NameUtil.makeMemberName((String)paramName);
                    if (socket.isEntrySocket()) {
                        if (w.isPlaceholderEmpty("inputParamAccess")) {
                            w.addToPlaceholder("inputParamAccess", "/* Input parameter access code");
                        }
                        w.addToPlaceholder("inputParamAccess", typeName + " " + paramVariableName + " = " + (typeName.equals("Object") ? "" : "(" + typeName + ") ") + "hc.getParam(" + paramIdent + ");");
                        continue;
                    }
                    if (w.isPlaceholderEmpty("outputParamAccess")) {
                        w.addToPlaceholder("outputParamAccess", "/* Output parameter access code");
                    }
                    w.addToPlaceholder("outputParamAccess", "" + typeName + " " + paramVariableName + ";");
                    w.addToPlaceholder("outputParamAccess", "hc.setResult(" + paramIdent + ", " + paramVariableName + ");");
                }
            }
        }
    }

    protected String makeSocketName(String name) {
        String stdName = StandardSocketNames.getStandardSocketNameIdentifier((String)name);
        if (stdName != null) {
            return stdName;
        }
        return "SOCKET_" + name.toUpperCase();
    }

    protected String makeParamName(String name) {
        return "PARAM_" + name.toUpperCase();
    }
}

