/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.template.standard;

import org.openbp.common.generic.PrintNameProvider;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.string.NameUtil;
import org.openbp.common.string.StringUtil;
import org.openbp.common.template.TemplateBase;
import org.openbp.common.template.writer.JavaTemplateWriter;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.type.DataTypeItem;

public abstract class JavaSrcTemplate
extends TemplateBase {
    private static final String[] collectionNames = new String[]{"list", "map", "table"};

    protected void printFileHeader(JavaTemplateWriter w) throws Exception {
        w.println((Object)"@[package]@");
        w.println();
        w.println((Object)"@[imports]@");
        w.println();
        w.println((Object)"// {{*Custom imports*");
        w.println((Object)"// }}*Custom imports*");
        w.println();
    }

    protected String createComment(DisplayObject o, String text) {
        String description;
        String displayName = o.getDisplayName();
        if (displayName != null) {
            displayName = StringUtil.capitalize((String)displayName);
        }
        if (displayName != null && !displayName.endsWith(".")) {
            displayName = displayName + ".";
        }
        if ((description = o.getDescription()) != null) {
            description = StringUtil.capitalize((String)description);
        }
        if (description != null && !description.endsWith(".")) {
            description = description + ".";
        }
        StringBuffer comment = new StringBuffer();
        if (displayName != null && description != null) {
            comment.append(displayName);
            if (text != null) {
                comment.append("\n");
                comment.append(text);
            }
            comment.append("\n");
            comment.append(description);
        } else if (displayName != null) {
            comment.append(displayName);
            if (text != null) {
                comment.append("\n");
                comment.append(text);
            }
        } else if (description != null) {
            comment.append(description);
            if (text != null) {
                comment.append("\n");
                comment.append(text);
            }
        } else {
            comment.append(NameUtil.makeDisplayName((String)o.getName()) + ".");
            if (text != null) {
                comment.append("\n");
                comment.append(text);
            }
        }
        comment.append("\n");
        return comment.toString();
    }

    protected String createComment(DisplayObject o) {
        return this.createComment(o, null);
    }

    protected String determineJavaType(JavaTemplateWriter w, DataTypeItem dataType) {
        String type = dataType.getClassName();
        if (type == null) {
            type = "Object";
        }
        type = type.equals("java.lang.Boolean") ? "boolean" : (type.equals("java.lang.Byte") ? "byte" : (type.equals("java.lang.Character") ? "char" : (type.equals("java.lang.Double") ? "double" : (type.equals("java.lang.Float") ? "float" : (type.equals("java.lang.Integer") ? "int" : (type.equals("java.lang.Long") ? "long" : (type.equals("java.lang.Short") ? "short" : (type.equals("[B") ? "byte[]" : this.extractUnqualifiedName(w, type)))))))));
        return type;
    }

    protected String extractUnqualifiedName(JavaTemplateWriter w, String qualifiedName) {
        String currentClass;
        String unqualifiedName;
        if (qualifiedName == null) {
            return null;
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot >= 0 && !(unqualifiedName = qualifiedName.substring(lastDot + 1, qualifiedName.length())).equals(currentClass = w.getClassName())) {
            if (!qualifiedName.startsWith("java.lang.")) {
                w.addImport(qualifiedName);
            }
            return unqualifiedName;
        }
        return qualifiedName;
    }

    protected String singular(String s) {
        String text;
        int i;
        if (s == null) {
            return null;
        }
        int sl = s.length();
        for (i = 0; i < collectionNames.length; ++i) {
            text = collectionNames[i] + " of ";
            if (!s.startsWith(text)) continue;
            return s.substring(text.length());
        }
        for (i = 0; i < collectionNames.length; ++i) {
            text = collectionNames[i];
            if (!s.endsWith(text)) continue;
            return s.substring(0, sl - text.length()).trim();
        }
        char lastChar = s.charAt(sl - 1);
        if (lastChar == 's') {
            return s.substring(0, sl - 1);
        }
        return s;
    }

    protected String removeDot(String s) {
        if (s != null && s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected String adverb(String s) {
        char[] vowl = new char[]{'a', 'e', 'i', 'o', 'u'};
        char firstChar = s.charAt(0);
        for (int i = 0; i < vowl.length; ++i) {
            if (vowl[i] != firstChar) continue;
            return "an";
        }
        return "a";
    }

    protected void errMsg(PrintNameProvider o, String msg) {
        if (o == null) {
            o = (Item)this.getProperty("item");
        }
        System.err.println("" + o.getPrintName() + ": " + msg);
    }

    protected void errMsg(String msg) {
        this.errMsg(null, msg);
    }
}

