/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item;

import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.icon.MultiImageIcon;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.type.ComplexTypeItem;
import org.openbp.core.model.item.type.DataTypeItem;

public final class ItemIconMgr {
    private static ItemIconMgr singletonInstance;
    private Hashtable iconMap = new Hashtable();

    public static synchronized ItemIconMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ItemIconMgr();
        }
        return singletonInstance;
    }

    private ItemIconMgr() {
    }

    public Icon getIcon(Item item, int preferredSize) {
        return this.getIcon(null, item, preferredSize);
    }

    public Icon getIcon(String skinName, Item item, int preferredSize) {
        return this.getIcon(skinName, item.getModelObjectSymbolName(), preferredSize);
    }

    public Icon getTypeIcon(DataTypeItem item, int preferredSize) {
        return this.getTypeIcon(null, item, preferredSize);
    }

    public Icon getTypeIcon(String skinName, DataTypeItem item, int preferredSize) {
        Icon icon = null;
        if (item != null) {
            icon = this.getIcon(skinName, "Type" + item.getName(), preferredSize);
            if (icon != null) {
                return icon;
            }
            if (item instanceof ComplexTypeItem && (icon = this.getIcon(skinName, "TypeBean", preferredSize)) != null) {
                return icon;
            }
        }
        if ((icon = this.getIcon(skinName, "TypeAny", preferredSize)) != null) {
            return icon;
        }
        icon = this.getIcon(skinName, "Type", preferredSize);
        if (icon != null) {
            return icon;
        }
        return null;
    }

    public Icon getIcon(String iconName, int preferredSize) {
        return this.getIcon(null, iconName, preferredSize);
    }

    public Icon getIcon(String skinName, String iconName, int preferredSize) {
        String key = skinName != null ? skinName + "." + iconName : iconName;
        Object o = this.iconMap.get(key);
        if (o instanceof MultiImageIcon) {
            MultiImageIcon mii = (MultiImageIcon)o;
            if (preferredSize != 0) {
                return mii.getIcon(preferredSize);
            }
            return mii;
        }
        if (o instanceof ImageIcon) {
            return (ImageIcon)o;
        }
        return null;
    }

    public void registerIcon(String name, Icon icon) {
        this.iconMap.put(name, icon);
    }

    public void registerIcon(String skinName, String name, Icon icon) {
        String key = skinName != null ? skinName + "." + name : name;
        this.iconMap.put(key, icon);
    }

    public static MultiIcon getMultiIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return new MultiImageIcon((ImageIcon)icon);
        }
        if (icon instanceof MultiIcon) {
            return (MultiIcon)icon;
        }
        return null;
    }
}

