/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemfilter;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openbp.core.model.item.Item;
import org.openbp.guiclient.model.item.itemfilter.ItemFilter;
import org.openbp.guiclient.model.item.itemfilter.ItemFilterHolder;
import org.openbp.guiclient.model.item.itemfilter.ItemFilterListener;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.action.JaspiraToolbarButton;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.swing.layout.VerticalFlowLayout;
import org.openbp.swing.plaf.sky.SkyTheme;

public class ItemFilterMgr
implements ItemFilterHolder {
    protected List filterList;
    private ItemFilterListener filterListener;
    private Plugin plugin;
    private JaspiraToolbar toolbar;
    private JComponent configPane;
    private boolean initDone;

    public ItemFilterMgr() {
    }

    public ItemFilterMgr(Plugin plugin) {
        this.plugin = plugin;
    }

    protected void initializeComponents() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        if (this.filterList != null) {
            int n = this.filterList.size();
            for (int i = 0; i < n; ++i) {
                ItemFilter filter = (ItemFilter)this.filterList.get(i);
                if (this.toolbar == null) {
                    this.toolbar = new JaspiraToolbar();
                    this.toolbar.setIconSize(16);
                }
                FilterToolbarAction action = new FilterToolbarAction(filter);
                action.setIcon(filter.getIcon());
                JaspiraToolbarButton button = new JaspiraToolbarButton(action);
                button.setSelected(filter.isActive());
                this.toolbar.add(button);
                button.invalidate();
                JComponent filterComponent = filter.getConfigurationComponent();
                if (filterComponent == null) continue;
                if (this.configPane == null) {
                    this.configPane = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
                    this.configPane.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
                    this.configPane.setVisible(false);
                }
                filterComponent.setVisible(false);
                filterComponent.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
                filterComponent.setBorder(new EmptyBorder(0, 0, 2, 2));
                this.configPane.add(filterComponent);
            }
        }
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean acceptsItem(Item item) {
        if (this.filterList != null) {
            int n = this.filterList.size();
            for (int i = 0; i < n; ++i) {
                ItemFilter filter = (ItemFilter)this.filterList.get(i);
                if (filter.acceptsItem(item)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void apply(ItemFilter filter) {
        if (this.filterListener != null) {
            this.filterListener.applyFilter(this, filter);
        }
    }

    public void setFilterListener(ItemFilterListener filterListener) {
        this.filterListener = filterListener;
    }

    public JaspiraToolbar getFilterToolbar() {
        this.initializeComponents();
        return this.toolbar;
    }

    public JComponent getConfigurationPane() {
        this.initializeComponents();
        return this.configPane;
    }

    public void addFilter(ItemFilter filter) {
        if (this.filterList == null) {
            this.filterList = new ArrayList();
        }
        this.filterList.add(filter);
        filter.setFilterHolder(this);
    }

    public List getFilterList() {
        return this.filterList;
    }

    private class FilterToolbarAction
    extends JaspiraAction {
        private ItemFilter filter;

        public FilterToolbarAction(ItemFilter filter) {
            super(filter);
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JButton button = (JButton)ae.getSource();
            JComponent filterComponent = this.filter.getConfigurationComponent();
            if (filterComponent != null) {
                boolean visible = filterComponent.isVisible();
                visible = !visible;
                filterComponent.setVisible(visible);
                if (!visible) {
                    this.filter.setActive(false);
                }
                button.setSelected(visible);
                boolean isOneComponentVisible = false;
                Component[] comps = ItemFilterMgr.this.configPane.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    isOneComponentVisible = true;
                    break;
                }
                ItemFilterMgr.this.configPane.setVisible(isOneComponentVisible);
            } else {
                boolean active = button.isSelected();
                this.filter.setActive(!active);
                button.setSelected(this.filter.isActive());
            }
        }
    }
}

