/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.ItemTypeDescriptor;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.model.item.ItemUtil;
import org.openbp.guiclient.model.item.itemfilter.AbstractItemFilter;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.action.JaspiraToolbarButton;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.swing.plaf.sky.SkyTheme;

public class ItemTypeFilter
extends AbstractItemFilter {
    private String[] supportedItemTypes;
    private List filteredItemTypes;
    private JPanel configurationComponent;
    private List actionList;
    private JaspiraToolbar toolbar;
    private String filterPrefix;

    public ItemTypeFilter() {
        this(null);
    }

    public ItemTypeFilter(String[] supportedItemTypes) {
        this.setSupportedItemTypes(supportedItemTypes);
        this.filteredItemTypes = new ArrayList();
        if (this.filterPrefix == null) {
            this.filterPrefix = this.getItemFilterResource().getRequiredString("filterprefix");
        }
    }

    public List getActions() {
        if (this.actionList == null && this.supportedItemTypes != null) {
            this.actionList = new ArrayList();
            for (int i = 0; i < this.supportedItemTypes.length; ++i) {
                String itemType = this.supportedItemTypes[i];
                ItemTypeDescriptor itd = ModelConnector.getInstance().getItemTypeDescriptor(itemType);
                ItemTypeToggleAction action = new ItemTypeToggleAction(this.getPlugin(), itd);
                String filterDescription = this.filterPrefix;
                ObjectDescriptor od = ItemUtil.obtainObjectDescriptor(itd);
                if (od != null) {
                    filterDescription = filterDescription + " " + od.getDisplayName();
                }
                action.setDescription(filterDescription);
                action.setIcon(ItemIconMgr.getMultiIcon(ItemIconMgr.getInstance().getIcon(itemType, 16)));
                this.actionList.add(action);
            }
        }
        return this.actionList;
    }

    public String[] getSupportedItemTypeInfos() {
        return this.supportedItemTypes;
    }

    public void setSupportedItemTypes(String[] supportedItemTypes) {
        if (supportedItemTypes == null) {
            supportedItemTypes = ModelConnector.getInstance().getItemTypes(3);
        }
        this.supportedItemTypes = supportedItemTypes;
    }

    public JaspiraToolbar getToolbar() {
        return this.toolbar;
    }

    @Override
    public boolean acceptsItem(Item item) {
        return this.acceptsItemType(item.getItemType());
    }

    public boolean acceptsItemType(String itemType) {
        if (this.filteredItemTypes.size() == 0) {
            return true;
        }
        return this.containsItemType(itemType);
    }

    @Override
    public JComponent getConfigurationComponent() {
        List actions;
        if (this.configurationComponent == null && this.supportedItemTypes != null && (actions = this.getActions()) != null) {
            this.toolbar = new JaspiraToolbar();
            this.toolbar.setIconSize(16);
            this.toolbar.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
            int n = actions.size();
            for (int i = 0; i < n; ++i) {
                ItemTypeToggleAction action = (ItemTypeToggleAction)actions.get(i);
                String itemType = action.getItemTypeDescriptor().getItemType();
                JaspiraToolbarButton toggle = new JaspiraToolbarButton(action);
                toggle.setSelected(this.containsItemType(itemType));
                toggle.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
                this.toolbar.add(toggle);
                toggle.invalidate();
                this.toolbar.invalidate();
            }
            JLabel label = new JLabel(this.getItemFilterResource().getRequiredString("type"));
            label.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.configurationComponent = new JPanel(new BorderLayout());
            this.configurationComponent.add((Component)label, "West");
            this.configurationComponent.add(this.toolbar);
        }
        return this.configurationComponent;
    }

    @Override
    public boolean isActive() {
        return this.filteredItemTypes.size() > 0;
    }

    @Override
    public void setActive(boolean active) {
        if (!active) {
            List actions;
            if (this.filteredItemTypes.size() > 0) {
                this.filteredItemTypes.clear();
                this.apply();
            }
            if ((actions = this.getActions()) != null) {
                int n = actions.size();
                for (int i = 0; i < n; ++i) {
                    ItemTypeToggleAction action = (ItemTypeToggleAction)actions.get(i);
                    action.setSelected(false);
                }
            }
        }
    }

    public void setEnabled(boolean enabled) {
        List actions = this.getActions();
        if (actions != null) {
            int n = actions.size();
            for (int i = 0; i < n; ++i) {
                ItemTypeToggleAction action = (ItemTypeToggleAction)actions.get(i);
                action.setEnabled(enabled);
            }
        }
    }

    public boolean containsItemType(String itemType) {
        int n = this.filteredItemTypes.size();
        for (int i = 0; i < n; ++i) {
            if (!itemType.equals(this.filteredItemTypes.get(i))) continue;
            return true;
        }
        return false;
    }

    protected void addItemType(String itemType) {
        if (!this.filteredItemTypes.contains(itemType)) {
            this.filteredItemTypes.add(itemType);
        }
    }

    protected void removeItemType(String itemType) {
        this.filteredItemTypes.remove(itemType);
    }

    private class ItemTypeToggleAction
    extends JaspiraAction {
        private ItemTypeDescriptor itd;

        public ItemTypeToggleAction(Plugin plugin, ItemTypeDescriptor itd) {
            super((DisplayObject)ItemUtil.obtainObjectDescriptor(itd));
            this.setPriority(itd.getSequence());
            this.itd = itd;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JaspiraToolbarButton button = (JaspiraToolbarButton)e.getSource();
            JaspiraAction action = button.getJaspiraAction();
            boolean selected = !action.isSelected();
            String itemType = this.itd.getItemType();
            if (selected) {
                ItemTypeFilter.this.addItemType(itemType);
            } else {
                ItemTypeFilter.this.removeItemType(itemType);
            }
            action.setSelected(selected);
            ItemTypeFilter.this.apply();
        }

        public ItemTypeDescriptor getItemTypeDescriptor() {
            return this.itd;
        }
    }
}

