/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.objectvalidators;

import java.util.HashMap;
import java.util.List;
import org.openbp.common.string.StringUtil;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.type.ComplexTypeItem;
import org.openbp.core.model.item.type.DataMember;
import org.openbp.guiclient.objectvalidators.ModelObjectValidator;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;

public class ComplexTypeValidator
extends ModelObjectValidator {
    @Override
    public boolean validateObject(Object editedObject, PropertyBrowser pb) {
        if (!super.validateObject(editedObject, pb)) {
            return false;
        }
        return this.validateMemberNames((ComplexTypeItem)editedObject);
    }

    @Override
    public boolean validateProperty(String propertyName, Object propertyValue, Object editedObject, PropertyEditor propertyEditor, boolean complete) {
        ComplexTypeItem type;
        Model model;
        if (!super.validateProperty(propertyName, propertyValue, editedObject, propertyEditor, complete)) {
            return false;
        }
        if (complete && propertyName.equals("Name") && (model = (type = (ComplexTypeItem)editedObject).getModel()) != null) {
            String oldName = type.getName();
            String oldClassName = type.getClassName();
            if (oldClassName != null && oldName != null) {
                String newName = (String)propertyValue;
                String className = StringUtil.substitute((String)oldClassName, (String)("." + oldName), (String)("." + newName));
                type.setClassName(className);
                propertyEditor.getOwner().reloadProperty("ClassName");
            }
        }
        return true;
    }

    protected boolean validateMemberNames(ComplexTypeItem type) {
        List allMembers = type.getAllMemberList();
        List members = type.getMemberList();
        if (members != null) {
            HashMap<String, String> reported = null;
            int n = members.size();
            for (int i = 0; i < n; ++i) {
                int count;
                DataMember member = (DataMember)members.get(i);
                String name = member.getName();
                if (reported != null && reported.get(name) != null || (count = this.countMembers(name, allMembers)) <= 1) continue;
                type.getModelMgr().getMsgContainer().addMsg((Object)member, "The member name conflicts with another member or this type or a member of its base type.");
                if (reported == null) {
                    reported = new HashMap<String, String>();
                }
                reported.put(name, name);
            }
        }
        return this.displayMsgContainer();
    }

    private int countMembers(String name, List members) {
        int count = 0;
        if (members != null) {
            int n = members.size();
            for (int i = 0; i < n; ++i) {
                DataMember member = (DataMember)members.get(i);
                if (!member.getName().equals(name)) continue;
                ++count;
            }
        }
        return count;
    }
}

