/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.plugins.displayobject;

import java.util.ArrayList;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.option.BooleanOption;
import org.openbp.jaspira.option.LocalizableOptionString;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.option.StringOption;
import org.openbp.jaspira.option.widget.RadioWidget;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.OptionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;

public final class DisplayObjectPlugin
extends AbstractPlugin {
    protected int titleMode = 2;
    public static final int TITLE_NAME = 1;
    public static final int TITLE_TEXT = 2;
    private static final String TITLEMODE_OPTION = "displayobject.options.titlemode";
    public static final String AUTODISPLAYNAME_OPTION = "displayobject.options.autodisplayname";
    private static DisplayObjectPlugin singletonInstance;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.standard";
    }

    public static synchronized DisplayObjectPlugin getInstance() {
        if (singletonInstance == null) {
            singletonInstance = (DisplayObjectPlugin)PluginMgr.getInstance().createInstance(DisplayObjectPlugin.class, (Plugin)ApplicationBase.getInstance());
        }
        return singletonInstance;
    }

    private void fireChanged(String eventName) {
        this.fireEvent(eventName);
    }

    public boolean isTitleModeText() {
        return this.titleMode == 2;
    }

    public int getTitleMode() {
        return this.titleMode;
    }

    public void setTitleMode(int titleMode) {
        this.titleMode = titleMode;
    }

    protected void readTitleModeOption() {
        String value = OptionMgr.getInstance().getStringOption(TITLEMODE_OPTION, "text");
        if ("name".equals(value)) {
            this.setTitleMode(1);
        } else {
            this.setTitleMode(2);
        }
    }

    public void saveTitleModeOption() {
        String value = null;
        value = this.getTitleMode() == 1 ? "name" : "text";
        Option option = OptionMgr.getInstance().getOption(TITLEMODE_OPTION);
        option.setValue(value);
        this.fireChanged("displayobject.changed.titlemode");
    }

    public class RoleOptionModule
    extends OptionModule {

        public class AutoGenerateDisplayNameOption
        extends BooleanOption {
            public AutoGenerateDisplayNameOption() {
                super(DisplayObjectPlugin.this.getPluginResourceCollection(), DisplayObjectPlugin.AUTODISPLAYNAME_OPTION, Boolean.FALSE);
            }
        }

        public class TitleOption
        extends StringOption {
            public TitleOption() {
                super(DisplayObjectPlugin.this.getPluginResourceCollection(), DisplayObjectPlugin.TITLEMODE_OPTION, "text");
            }

            @Override
            public OptionWidget createOptionWidget() {
                ArrayList<LocalizableOptionString> values = new ArrayList<LocalizableOptionString>();
                ResourceCollection res = DisplayObjectPlugin.this.getPluginResourceCollection();
                values.add(new LocalizableOptionString(res.getRequiredString("displayobject.options.titlemode.value.text"), "text"));
                values.add(new LocalizableOptionString(res.getRequiredString("displayobject.options.titlemode.value.name"), "name"));
                return new RadioWidget(this, values);
            }
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.displayobject";
        }

        public JaspiraEventHandlerCode titlemode(JaspiraActionEvent jae) {
            DisplayObjectPlugin.this.titleMode = DisplayObjectPlugin.this.titleMode == 1 ? 2 : 1;
            DisplayObjectPlugin.this.saveTitleModeOption();
            return EVENT_HANDLED;
        }
    }
}

