/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.util;

import org.openbp.common.setting.SettingUtil;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.type.DataTypeItem;

public class ClassNameBuilderUtil {
    private ClassNameBuilderUtil() {
    }

    public static String constructActivityClassName(ActivityItem activity) {
        String className = ClassNameBuilderUtil.constructClassNamePrefix((Item)activity);
        if (className != null) {
            className = className + '.' + "activity" + '.' + activity.getName() + "Activity";
        }
        return className;
    }

    public static String constructTypeClassName(DataTypeItem type) {
        String className = ClassNameBuilderUtil.constructClassNamePrefix((Item)type);
        if (className != null) {
            className = className + '.' + "data" + '.' + type.getName();
        }
        return className;
    }

    public static String constructClassNamePrefix(Item item) {
        Model model = item.getOwningModel();
        if (model != null) {
            String pkg = model.getDefaultPackage();
            if (pkg == null) {
                pkg = SettingUtil.getStringSetting((String)"openbp.cockpit.defaultModelPackageBaseName");
                if (pkg == null) {
                    pkg = "org.openbp.model";
                }
                pkg = pkg + "." + model.getName().toLowerCase();
            }
            return pkg;
        }
        return null;
    }
}

