/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openbp.jaspira.action.JaspiraAction;

public final class ActionMgr {
    private Map actions = new HashMap();
    private static ActionMgr singleton;

    private ActionMgr() {
        this.actions.put("menuroot", new JaspiraAction("menuroot", null, null, null, null, 0, "group"));
        this.actions.put("toolbarroot", new JaspiraAction("toolbarroot", null, null, null, null, 0, "group"));
    }

    public static synchronized ActionMgr getInstance() {
        if (singleton == null) {
            singleton = new ActionMgr();
        }
        return singleton;
    }

    public void addAction(JaspiraAction action) {
        String toolbarparentname;
        String name = action.getName();
        JaspiraAction current = (JaspiraAction)this.actions.get(name);
        if (current == null) {
            current = action;
            this.actions.put(name, current);
        }
        current.increaseCounter();
        String menuparentname = current.getActionPropertyString("menuparent");
        if (menuparentname != null) {
            JaspiraAction menuparent = this.getAction(menuparentname);
            if (menuparent == null) {
                menuparent = new JaspiraAction(current.getActionResource(), menuparentname);
                this.addAction(menuparent);
            }
            menuparent.addMenuChild(current);
        }
        if ((toolbarparentname = current.getActionPropertyString("toolbarparent")) != null) {
            JaspiraAction toolbarparent = this.getAction(toolbarparentname);
            if (toolbarparent == null) {
                toolbarparent = new JaspiraAction(current.getActionResource(), toolbarparentname);
                this.addAction(toolbarparent);
            }
            toolbarparent.addToolbarChild(current);
        }
    }

    public JaspiraAction removeAction(String name) {
        JaspiraAction action = (JaspiraAction)this.actions.get(name);
        if (action == null) {
            return null;
        }
        if (!action.decreaseCounter()) {
            this.actions.remove(name);
        }
        return action;
    }

    public JaspiraAction removeAction(JaspiraAction action) {
        return this.removeAction(action.getName());
    }

    public void removeAllActions(Collection actions) {
        if (actions != null) {
            Iterator it = actions.iterator();
            while (it.hasNext()) {
                this.removeAction((JaspiraAction)it.next());
            }
        }
    }

    public JaspiraAction getAction(String name) {
        return (JaspiraAction)this.actions.get(name);
    }

    public static char getMnemonicChar(String s) {
        int pos = s.indexOf("_");
        if (pos != -1) {
            return s.charAt(pos + 1);
        }
        return '\u0000';
    }

    public static String getStringWithoutMnemonicDelimiter(String s) {
        if (s == null) {
            return null;
        }
        int mnemonicpos = s.indexOf("_");
        if (mnemonicpos == -1) {
            return s;
        }
        return s.substring(0, mnemonicpos) + s.substring(mnemonicpos + 1);
    }
}

