/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.openbp.common.ExceptionUtil;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.plugin.Plugin;

public class JaspiraActionEvent
extends JaspiraEvent
implements Transferable {
    private Transferable transferable;
    private ActionEvent actionEvent;

    public JaspiraActionEvent(Plugin source, String eventName, Transferable transferable, int level, ActionEvent actionEvent) {
        super(source, eventName, 2, level);
        this.transferable = transferable;
        this.actionEvent = actionEvent;
    }

    public JaspiraActionEvent(Plugin source, String eventName, ActionEvent actionEvent, int level) {
        super(source, eventName, 2, level);
        this.actionEvent = actionEvent;
    }

    public JaspiraActionEvent(Plugin source, String eventName, int level) {
        super(source, eventName, 2, level);
    }

    public ActionEvent getActionEvent() {
        return this.actionEvent;
    }

    public boolean hasTransferable() {
        return this.transferable != null;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.transferable != null ? this.transferable.getTransferData(flavor) : null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.transferable != null ? this.transferable.getTransferDataFlavors() : new DataFlavor[]{};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.transferable != null ? this.transferable.isDataFlavorSupported(flavor) : false;
    }

    public Object getSafeTransferData(DataFlavor flavor) {
        try {
            return this.transferable.getTransferData(flavor);
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        return null;
    }
}

