/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import org.openbp.common.icon.FlexibleSize;
import org.openbp.common.icon.MultiIcon;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.jaspira.gui.plugin.PluginPanel;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.swing.AdvancedAccelerator;

public class JaspiraToolbarButton
extends JButton
implements ActionListener,
FlexibleSize,
PropertyChangeListener,
HierarchyListener,
AdvancedAccelerator {
    private JaspiraAction action;
    private MultiIcon icon;

    public JaspiraToolbarButton(JaspiraAction action) {
        this.action = action;
        this.copyFromAction(null);
        action.addPropertyChangeListener(this);
        this.addActionListener(this);
        this.icon = action.getIcon();
        this.setIcon((Icon)this.icon);
        if (this.icon == null) {
            this.setText(action.getDisplayText());
        }
    }

    private void copyFromAction(String propertyName) {
        if (propertyName == null || propertyName.equals("name")) {
            this.setActionCommand(this.action.getName());
        }
        if (propertyName == null || propertyName.equals("description")) {
            this.setToolTipText(this.action.getDescription());
        }
        if (propertyName == null || propertyName.equals("enabled")) {
            this.setEnabled(this.action.isEnabled());
        }
        if (propertyName == null || propertyName.equals("selected")) {
            this.setSelected(this.action.isSelected());
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public String getAcceleratorString() {
        KeySequence[] ks = this.action.getKeySequences();
        if (ks != null && ks.length > 0) {
            return ks[0].toString();
        }
        return null;
    }

    public JaspiraAction getJaspiraAction() {
        return this.action;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (!this.isShowing()) {
            this.action.removePropertyChangeListener(this);
        } else {
            this.action.addPropertyChangeListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        for (Container c = this; c != null; c = c.getParent()) {
            PluginPanel pluginPanel;
            VisiblePlugin plugin;
            if (!(c instanceof PluginPanel) || (plugin = (pluginPanel = (PluginPanel)c).getPlugin()) == null) continue;
            plugin.focusPlugin();
        }
        this.action.actionPerformed(event);
    }

    public int getIconSize() {
        return this.icon.getIconSize();
    }

    public void setIconSize(int size) {
        if (this.icon == null) {
            return;
        }
        this.icon.setIconSize(size);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.copyFromAction(evt.getPropertyName());
    }
}

