/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action.keys;

import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.openbp.jaspira.action.keys.KeySequence;

public class KeyTree {
    private KeyTree parent;
    private Map entries;
    private KeySequence sequence;
    private int refCount;

    public KeyTree() {
        this(null, null);
    }

    public KeyTree(KeyTree parent, KeySequence sequence) {
        this.parent = parent;
        this.sequence = sequence;
    }

    public void addSequence(KeySequence sequence) {
        KeyTree sub;
        int depth;
        ++this.refCount;
        int n = depth = this.parent != null ? this.sequence.length() : 0;
        if (sequence.length() <= depth) {
            return;
        }
        KeyStroke ks = sequence.getKeyAt(depth);
        if (this.entries == null) {
            this.entries = new HashMap();
        }
        if ((sub = (KeyTree)this.entries.get(ks)) == null) {
            sub = new KeyTree(this, sequence.getSubSequence(depth + 1));
            this.entries.put(ks, sub);
        }
        sub.addSequence(sequence);
    }

    public boolean removeSequence(KeySequence sequence) {
        if (--this.refCount <= 0) {
            return false;
        }
        if (sequence.length() == 0) {
            return true;
        }
        KeyTree sub = this.getSubTree(sequence.getKeyAt(0));
        if (sub != null && !sub.removeSequence(sequence.getSequenceTail())) {
            this.entries.remove(sequence.getKeyAt(0));
            if (this.entries.isEmpty()) {
                this.entries = null;
            }
        }
        return true;
    }

    public boolean hasChildren() {
        return this.entries != null && !this.entries.isEmpty();
    }

    public int getNumberOfChildren() {
        return this.entries != null ? this.entries.size() : 0;
    }

    public KeyTree getSubTree(KeyStroke stroke) {
        return this.entries != null ? (KeyTree)this.entries.get(stroke) : null;
    }

    public KeyStroke[] keys() {
        KeyStroke[] keys = new KeyStroke[this.getNumberOfChildren()];
        if (this.entries != null) {
            this.entries.keySet().toArray(keys);
        }
        return keys;
    }

    public KeyTree[] subTrees() {
        KeyTree[] keys = new KeyTree[this.getNumberOfChildren()];
        if (this.entries != null) {
            this.entries.values().toArray(keys);
        }
        return keys;
    }

    public KeySequence getSequence() {
        return this.sequence;
    }

    public String toString() {
        return this.sequence != null ? this.sequence.toString() : "*RootTree*";
    }
}

