/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.event;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import org.openbp.common.ExceptionUtil;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraPopupMenu;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.plugin.Plugin;

public class InteractionEvent
extends JaspiraEvent
implements Transferable {
    public static final String EVENTBASE = "global.interaction.";
    public static final String POPUP = "popup";
    public static final String MENU = "menu";
    public static final String TOOLBAR = "toolbar";
    private Transferable transferable;
    private JaspiraAction virtualRoot;

    public InteractionEvent(Plugin source, String type, Transferable transferable) {
        super(source, EVENTBASE + type, null, 2, type.equals(POPUP) ? 0 : 2, 1);
        if (transferable == null && POPUP.equals(type)) {
            throw new NullPointerException("Transferable must not be null for Popups!");
        }
        this.transferable = transferable;
    }

    public InteractionEvent(Plugin source, String type, Object o) {
        super(source, EVENTBASE + type, o, 2, type.equals(POPUP) ? 0 : 2, 1);
        if (o == null && POPUP.equals(type)) {
            throw new NullPointerException("Argument must not be null for Popups!");
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.transferable == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.transferable.getTransferData(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.transferable != null ? this.transferable.getTransferDataFlavors() : new DataFlavor[]{};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.transferable != null ? this.transferable.isDataFlavorSupported(flavor) : false;
    }

    public Object getSafeTransferData(DataFlavor flavor) {
        try {
            if (this.transferable != null) {
                return this.transferable.getTransferData(flavor);
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        return null;
    }

    public void add(JaspiraAction action) {
        if (this.virtualRoot == null) {
            this.virtualRoot = new JaspiraAction("root", null, null, null, null, 1, MENU);
        }
        this.virtualRoot.addMenuChild(action);
        this.virtualRoot.addToolbarChild(action);
    }

    public JaspiraPopupMenu createPopupMenu() {
        if (this.virtualRoot == null) {
            return null;
        }
        JaspiraPopupMenu menu = new JaspiraPopupMenu();
        SortedSet menuchildren = this.virtualRoot.getMenuchildren();
        if (menuchildren == null) {
            return null;
        }
        Iterator it = menuchildren.iterator();
        while (it.hasNext()) {
            JaspiraAction next = (JaspiraAction)it.next();
            if (next.getType().equals("group")) {
                if (next.getMenuchildren() == null) continue;
                Iterator it2 = next.getMenuchildren().iterator();
                while (it2.hasNext()) {
                    menu.add((JaspiraAction)it2.next());
                }
            } else {
                menu.add(next);
            }
            if (!it.hasNext()) continue;
            menu.addSeparator();
        }
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        menu.setInvoker(focusOwner);
        return menu;
    }

    public JaspiraToolbar createToolbar() {
        if (this.virtualRoot == null) {
            return null;
        }
        JaspiraToolbar toolbar = new JaspiraToolbar();
        if (this.virtualRoot.getToolbarchildren() != null) {
            for (JaspiraAction action : this.virtualRoot.getToolbarchildren()) {
                JComponent item = action.toToolBarComponent();
                if (item == null) continue;
                toolbar.add(item);
                toolbar.addSeparator();
            }
        }
        return toolbar;
    }
}

