/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.geom.RectangularShape;
import java.util.Timer;
import java.util.TimerTask;
import org.openbp.jaspira.gui.interaction.BasicDropRegion;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.swing.SwingUtil;

public class BasicDragReactor
extends BasicDropRegion {
    private Timer timer;
    private long delay;

    public BasicDragReactor(Object id, InteractionClient parent, RectangularShape shape, Component origin, long delay) {
        super(id, parent, shape, origin);
        this.delay = delay;
    }

    public BasicDragReactor(Object id, InteractionClient parent, Component source, long delay) {
        super(id, parent, source);
        this.delay = delay;
    }

    @Override
    public boolean canImport() {
        return false;
    }

    @Override
    public boolean dragEnter() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Point p = ApplicationBase.getInstance().getActiveFrame().getDragDropPane().getLastLocation();
                BasicDragReactor.this.parent.dragActionTriggered(BasicDragReactor.this.id, SwingUtil.convertFromGlassCoords((Point)p, (Component)BasicDragReactor.this.origin));
            }
        }, this.delay);
        return true;
    }

    @Override
    public boolean dragExit() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        return true;
    }

    @Override
    public boolean importData(Transferable data, Point p) {
        return false;
    }
}

