/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openbp.common.ExceptionUtil;

public class BasicTransferable
implements Transferable {
    protected Object data;
    private Set supportedFlavors;

    public BasicTransferable(Object data) {
        this(data, null);
    }

    public BasicTransferable(Object data, List exclusions) {
        this.data = data;
        this.supportedFlavors = new HashSet();
        if (data != null) {
            this.buildClassFlavors(data.getClass(), exclusions);
        }
    }

    private void buildClassFlavors(Class cls, List exclusions) {
        if (cls == null) {
            return;
        }
        if (exclusions == null || !exclusions.contains(cls)) {
            this.supportedFlavors.add(new DataFlavor(cls, cls.getName()));
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.buildClassFlavors(interfaces[i], exclusions);
        }
        this.buildClassFlavors(cls.getSuperclass(), exclusions);
    }

    @Override
    public final Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Object result = this.getUserTransferData(flavor);
        if (result != null) {
            return result;
        }
        if (this.supportedFlavors.contains(flavor)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public Object getUserTransferData(DataFlavor flavor) throws IOException {
        return null;
    }

    @Override
    public final DataFlavor[] getTransferDataFlavors() {
        Collection userFlavors = this.getUserTransferDataFlavors();
        DataFlavor[] flavors = new DataFlavor[this.supportedFlavors.size() + userFlavors.size()];
        int i = 0;
        Iterator it = userFlavors.iterator();
        while (it.hasNext()) {
            flavors[i] = (DataFlavor)it.next();
            ++i;
        }
        it = this.supportedFlavors.iterator();
        while (it.hasNext()) {
            flavors[i] = (DataFlavor)it.next();
            ++i;
        }
        return flavors;
    }

    public Collection getUserTransferDataFlavors() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public final boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.getUserTransferDataFlavors().contains(flavor) || this.supportedFlavors.contains(flavor);
    }

    public Object getSafeTransferData(DataFlavor flavor) {
        try {
            return this.getTransferData(flavor);
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        return null;
    }
}

