/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import org.openbp.jaspira.gui.interaction.BasicDropRegion;
import org.openbp.jaspira.gui.interaction.InteractionClient;

public class CircleDropRegion
extends BasicDropRegion {
    private Ellipse2D circle;

    public CircleDropRegion(Object id, InteractionClient parent, RectangularShape shape, int diameter, Component origin) {
        super(id, parent, shape, origin);
        Point2D.Double center = new Point2D.Double(shape.getCenterX(), shape.getCenterY());
        this.circle = new Ellipse2D.Double(((Point2D)center).getX() - (double)diameter / 2.0, ((Point2D)center).getY() - (double)diameter / 2.0, diameter, diameter);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setPaint(this.getPaint());
        g.fill(this.circle);
    }

    @Override
    public Rectangle getBounds() {
        return this.circle.getBounds();
    }
}

