/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.text.JTextComponent;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.jaspira.gui.interaction.BasicCursorPrototype;
import org.openbp.jaspira.gui.interaction.BreakoutBoxEntry;
import org.openbp.jaspira.gui.interaction.BreakoutProvider;
import org.openbp.jaspira.gui.interaction.CursorPrototype;
import org.openbp.jaspira.gui.interaction.DragAwareRegion;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.jaspira.gui.interaction.DropPaneContainer;
import org.openbp.jaspira.gui.interaction.InteractionClient;

public class DragDropPane
extends JComponent {
    public static CursorPrototype acceptCursorPrototype;
    public static CursorPrototype rejectCursorPrototype;
    private static final int BOB_ENTRY_SIZE = 60;
    private static final int BOB_CIRCLE_SIZE = 32;
    private static final String ESCAPE = "escape";
    private Set dropClients;
    private Composite composite;
    private List currentRegions;
    private DragAwareRegion currentRegion;
    private Transferable currentTransferable;
    private List currentFlavors;
    private DragOrigin currentDragOrigin;
    private MultiIcon currentDragIcon;
    private Cursor currentAcceptCursor;
    private Cursor currentRejectCursor;
    private MouseEvent mouseEvent;
    private Point lastLocation;
    private boolean breakoutshown;
    private BreakoutBoxEntry[] bobEntries;
    private MouseInputListener bobMouseListener;
    private MouseWheelListener bobMouseWheelListener;
    private Point bobPosition;
    private Point bobDropPoint;
    private int bobRadius;
    private double angleDelta;
    private double angleOffset;
    private String recentlySelectedEntryTitle;
    private int animationPos = -1;
    private double animationAngle;
    private Timer animationTimer;
    private static int[] animationControl;
    private static int animationLevels;
    private static long animationInterval;
    private static final double CIRCLE = Math.PI * 2;

    public static DragDropPane installDragDropPane(DropPaneContainer container) {
        Component glassPane = container.getGlassPane();
        if (glassPane instanceof DragDropPane) {
            return (DragDropPane)glassPane;
        }
        DragDropPane pane = new DragDropPane();
        container.setDragDropPane(pane);
        return pane;
    }

    private DragDropPane() {
        this.setOpaque(false);
        this.setTransparency(0.2f);
        this.dropClients = new HashSet();
        this.currentRegions = new ArrayList();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.registerBobCloseAction();
        this.lastLocation = new Point();
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.currentFlavors != null) {
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(this.composite);
            Iterator it = this.currentRegions.iterator();
            while (it.hasNext()) {
                ((DragAwareRegion)it.next()).draw(g2);
            }
            if (this.currentRegion != null && this.currentRegion.getOverlay() != null) {
                g2.setColor(Color.BLACK);
                g2.draw(this.currentRegion.getOverlay());
            }
            g2.setComposite(oldComposite);
        } else if (this.bobEntries != null) {
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(this.composite);
            g2.setColor(Color.BLUE);
            g2.fillOval(this.bobPosition.x - this.bobRadius, this.bobPosition.y - this.bobRadius, this.bobRadius * 2, this.bobRadius * 2);
            g2.setComposite(oldComposite);
            g2.drawOval(this.bobPosition.x - 5, this.bobPosition.y - 5, 10, 10);
            for (int i = 0; i < this.bobEntries.length; ++i) {
                this.bobEntries[i].draw(g);
            }
        }
    }

    public void regionsInvalidated() {
        this.repaintRegions();
        this.currentRegions.clear();
        if (this.currentFlavors != null) {
            for (InteractionClient next : this.dropClients) {
                List regions = next.getAllDropRegions(this.currentFlavors, this.currentTransferable, this.mouseEvent);
                if (regions == null) continue;
                this.currentRegions.addAll(regions);
            }
        }
        this.repaintRegions();
    }

    private void repaintRegions() {
        Rectangle invalidateRect = new Rectangle();
        for (DragAwareRegion region : this.currentRegions) {
            Rectangle r = region.getBounds();
            invalidateRect.add(r);
        }
        this.repaint(invalidateRect);
    }

    public void startDrag(Transferable transferable, DragOrigin dragOrigin, MouseEvent mouseEvent) {
        this.currentTransferable = transferable;
        this.currentDragOrigin = dragOrigin;
        this.currentFlavors = Arrays.asList(this.currentTransferable.getTransferDataFlavors());
        this.mouseEvent = mouseEvent;
        this.setVisible(true);
        this.currentDragIcon = this.currentDragOrigin.getDragImage();
        this.currentAcceptCursor = acceptCursorPrototype.createCursor(this.currentDragIcon);
        this.currentRejectCursor = rejectCursorPrototype.createCursor(this.currentDragIcon);
        this.setCursor(this.currentRejectCursor);
        Iterator it = this.dropClients.iterator();
        while (it.hasNext()) {
            ((InteractionClient)it.next()).dragStarted(this.currentTransferable);
        }
        this.regionsInvalidated();
    }

    public void cancelDrag() {
        if (this.currentTransferable != null && this.currentDragOrigin != null) {
            this.currentDragOrigin.dropCanceled(this.currentTransferable);
        }
        this.endDrag();
    }

    public void endDrag() {
        Transferable oldTransferable = this.currentTransferable;
        this.currentDragOrigin = null;
        this.currentRegion = null;
        this.currentRegions.clear();
        this.currentFlavors = null;
        this.currentTransferable = null;
        this.mouseEvent = null;
        this.currentDragIcon = null;
        this.currentAcceptCursor = null;
        this.currentRejectCursor = null;
        if (oldTransferable != null) {
            Iterator it = this.dropClients.iterator();
            while (it.hasNext()) {
                ((InteractionClient)it.next()).dragEnded(oldTransferable);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.setVisible(false);
    }

    public void startBreakOutMode(BreakoutProvider provider, Point position) {
        if (FocusManager.getCurrentManager().getFocusOwner() instanceof JTextComponent) {
            return;
        }
        this.bobMouseListener = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DragDropPane.this.breakoutshown) {
                    if (DragDropPane.this.bobEntries != null) {
                        for (int i = 0; i < DragDropPane.this.bobEntries.length; ++i) {
                            if (!DragDropPane.this.bobEntries[i].reactsOn(e.getX(), e.getY())) continue;
                            BreakoutBoxEntry bobEntry = DragDropPane.this.bobEntries[i];
                            DragDropPane.this.endBreakOutMode();
                            bobEntry.importData(DragDropPane.this.bobDropPoint);
                            DragDropPane.this.recentlySelectedEntryTitle = bobEntry.getToolTipText();
                            return;
                        }
                    }
                    DragDropPane.this.endBreakOutMode();
                    return;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DragDropPane.this.lastLocation = e.getPoint();
            }
        };
        this.addMouseListener(this.bobMouseListener);
        this.addMouseMotionListener(this.bobMouseListener);
        this.bobMouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                DragDropPane.this.rotateBobEntries(notches);
            }
        };
        this.addMouseWheelListener(this.bobMouseWheelListener);
        this.bobPosition = new Point(position);
        this.bobDropPoint = new Point(position);
        this.lastLocation = new Point(this.bobDropPoint);
        this.buildBreakOutMenu(provider);
        this.showBreakOutMenu();
        this.setVisible(true);
        this.breakoutshown = true;
    }

    public void endBreakOutMode() {
        if (this.breakoutshown) {
            int r = this.bobRadius + 60;
            Rectangle invalidateRect = new Rectangle(this.bobPosition.x - r, this.bobPosition.y - r, 2 * r, 2 * r);
            this.repaint(invalidateRect);
            this.bobEntries = null;
            this.breakoutshown = false;
        }
        this.removeMouseListener(this.bobMouseListener);
        this.removeMouseMotionListener(this.bobMouseListener);
        this.bobMouseListener = null;
        this.removeMouseWheelListener(this.bobMouseWheelListener);
        this.bobMouseWheelListener = null;
        Point pos = this.getLocationOnScreen();
        pos.translate(this.lastLocation.x, this.lastLocation.y);
        this.setVisible(false);
    }

    private void buildBreakOutMenu(BreakoutProvider provider) {
        ArrayList importers = new ArrayList();
        for (InteractionClient client : this.dropClients) {
            List clientImporters = client.getAllImportersAt(this.bobDropPoint);
            if (clientImporters == null) continue;
            importers.addAll(clientImporters);
        }
        this.bobEntries = provider.createBreakOutEntries(importers);
        this.bobRadius = Math.max((int)Math.round((double)(this.bobEntries.length * 60) / (Math.PI * 2)), 30);
        this.bobPosition.translate(-this.bobRadius, 0);
        this.angleOffset = 0.0;
        this.angleDelta = Math.PI * 2 / (double)this.bobEntries.length;
        if (this.recentlySelectedEntryTitle != null) {
            for (int i = 0; i < this.bobEntries.length; ++i) {
                if (!this.recentlySelectedEntryTitle.equals(this.bobEntries[i].getToolTipText())) continue;
                this.angleOffset += (double)i * this.angleDelta;
            }
        }
    }

    private void showBreakOutMenu() {
        this.angleOffset = DragDropPane.normalizeAngle(this.angleOffset);
        Rectangle invalidateRect = new Rectangle();
        int n = this.bobEntries.length;
        for (int i = 0; i < n; ++i) {
            Rectangle rect = new Rectangle(this.bobPosition.x, this.bobPosition.y, 32, 32);
            double alpha = this.angleOffset + this.angleDelta * (double)(n - i) + 1.5707963267948966;
            rect.x += (int)Math.round(Math.sin(alpha) * (double)this.bobRadius) - 16;
            rect.y += (int)Math.round(Math.cos(alpha) * (double)this.bobRadius) - 16;
            this.bobEntries[i].setLocationOnGlassPanel(rect);
            Rectangle invalid = new Rectangle(rect);
            invalid.grow(10, 10);
            invalidateRect.add(invalid);
        }
        int xDiff = 0;
        int yDiff = 0;
        Rectangle screenRect = this.getBounds();
        if (invalidateRect.x < screenRect.x) {
            xDiff = screenRect.x - invalidateRect.x;
        } else if (invalidateRect.x + invalidateRect.width > screenRect.x + screenRect.width) {
            xDiff = screenRect.x + screenRect.width - (invalidateRect.x + invalidateRect.width);
        }
        if (invalidateRect.y < screenRect.y) {
            yDiff = screenRect.y - invalidateRect.y;
        } else if (invalidateRect.y + invalidateRect.height > screenRect.y + screenRect.height) {
            yDiff = screenRect.y + screenRect.height - (invalidateRect.y + invalidateRect.height);
        }
        if (xDiff != 0 || yDiff != 0) {
            this.bobPosition.translate(xDiff, yDiff);
            invalidateRect.translate(xDiff, yDiff);
            for (int i = 0; i < n; ++i) {
                Rectangle rect = this.bobEntries[i].getLocationOnGlassPanel();
                rect.translate(xDiff, yDiff);
                this.bobEntries[i].setLocationOnGlassPanel(rect);
            }
        }
        this.repaint(invalidateRect);
    }

    private void rotateBobEntries(int delta) {
        int n;
        double angleToMove = (double)(-delta) * this.angleDelta;
        if (this.animationTimer != null) {
            this.endAnimation();
            angleToMove += this.getRemainingAnimationAngle();
        }
        if ((n = this.bobEntries.length) == 0) {
            return;
        }
        if ((delta %= n) == 0) {
            return;
        }
        this.animationPos = 0;
        this.animationAngle = angleToMove / (double)animationLevels;
        this.animationTimer = new Timer("Breakout menu animation timer");
        this.animationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!DragDropPane.this.advanceAnimation()) {
                    DragDropPane.this.endAnimation();
                    DragDropPane.this.angleOffset += DragDropPane.this.getRemainingAnimationAngle();
                    DragDropPane.this.showBreakOutMenu();
                }
            }
        }, 0L, animationInterval);
    }

    private void endAnimation() {
        if (this.animationTimer != null) {
            this.animationTimer.cancel();
            this.animationTimer = null;
        }
    }

    private double getRemainingAnimationAngle() {
        double remainingAngle = 0.0;
        if (this.animationPos >= 0 && this.animationPos < animationControl.length) {
            int n = 0;
            for (int i = this.animationPos; i < animationControl.length; ++i) {
                n += animationControl[i];
            }
            remainingAngle = (double)n * this.animationAngle;
        }
        return remainingAngle;
    }

    private boolean advanceAnimation() {
        if (this.animationPos < 0) {
            return false;
        }
        this.angleOffset += (double)animationControl[this.animationPos] * this.animationAngle;
        this.showBreakOutMenu();
        return ++this.animationPos < animationControl.length;
    }

    private void registerBobCloseAction() {
        this.getActionMap().put(ESCAPE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DragDropPane.this.breakoutshown && DragDropPane.this.isVisible()) {
                    DragDropPane.this.endBreakOutMode();
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, true), ESCAPE);
    }

    public void mouseDragged(Point p) {
        this.lastLocation = p;
        DragAwareRegion newRegion = this.getRegionAt(p);
        if (newRegion != this.currentRegion) {
            if (this.currentRegion != null) {
                this.currentRegion.dragExit();
            }
            this.currentRegion = newRegion;
            if (this.currentRegion != null) {
                this.currentRegion.dragEnter();
                CursorPrototype cursor = this.currentRegion.getCursor();
                if (cursor != null) {
                    this.setCursor(cursor.createCursor(this.currentDragIcon));
                } else if (this.currentRegion != null && this.currentRegion.canImport()) {
                    this.setCursor(this.currentAcceptCursor);
                } else {
                    this.setCursor(this.currentRejectCursor);
                }
            } else {
                this.setCursor(this.currentRejectCursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(Point p) {
        try {
            if (this.currentDragOrigin != null) {
                if (this.currentRegion != null && this.currentTransferable != null) {
                    this.currentDragOrigin.dropAccepted(this.currentTransferable);
                    if (this.currentRegion.importData(this.currentTransferable, p)) {
                        this.currentDragOrigin.dropPerformed(this.currentTransferable);
                    } else {
                        this.currentDragOrigin.dropCanceled(this.currentTransferable);
                    }
                } else {
                    this.currentDragOrigin.dropCanceled(this.currentTransferable);
                }
            }
        }
        finally {
            this.endDrag();
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            if (this.currentFlavors != null && this.currentRegion != null) {
                return this.currentRegion.getToolTipText();
            }
            if (this.bobEntries != null) {
                for (int i = 0; i < this.bobEntries.length; ++i) {
                    if (!this.bobEntries[i].reactsOn(event.getX(), event.getY())) continue;
                    return this.bobEntries[i].getToolTipText();
                }
            }
        }
        return null;
    }

    private DragAwareRegion getRegionAt(Point p) {
        for (DragAwareRegion region : this.currentRegions) {
            if (!region.reactsOn(p.x, p.y)) continue;
            return region;
        }
        return null;
    }

    public void addDropClient(InteractionClient client) {
        this.dropClients.add(client);
    }

    public void removeDropClient(InteractionClient client) {
        this.dropClients.remove(client);
    }

    public void clearDropClients() {
        this.dropClients.clear();
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setTransparency(float alpha) {
        this.setComposite(AlphaComposite.getInstance(3, alpha));
    }

    public DragOrigin getDragOrigin() {
        return this.currentDragOrigin;
    }

    public Point getLastLocation() {
        return this.lastLocation;
    }

    public MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    private static double normalizeAngle(double angle) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    static {
        animationControl = new int[]{1, 2, 4, 7, 12, 20, 12, 7, 4, 2, 1};
        animationLevels = 0;
        for (int i = 0; i < animationControl.length; ++i) {
            animationLevels += animationControl[i];
        }
        animationInterval = 50L;
        ResourceCollection res = ResourceCollectionMgr.getDefaultInstance().getResource("jaspira", DragDropPane.class);
        acceptCursorPrototype = new BasicCursorPrototype(null, ((ImageIcon)res.getRequiredObject("cursor.dragaccept")).getImage(), new Point());
        rejectCursorPrototype = new BasicCursorPrototype(null, ((ImageIcon)res.getRequiredObject("cursor.dragreject")).getImage(), new Point());
    }
}

