/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openbp.jaspira.gui.interaction.DragDropPane;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.swing.SwingUtil;

public class DragInitiator
implements MouseListener,
MouseMotionListener,
KeyListener {
    private DragOrigin owner;
    private Component component;
    private DragDropPane dndPane;
    private int clickX;
    private int clickY;
    private boolean dragging;

    public static void makeDraggable(Component comp, DragOrigin owner) {
        new DragInitiator(owner, comp);
    }

    private DragInitiator(DragOrigin owner, Component component) {
        this.owner = owner;
        this.component = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addKeyListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.clickX = e.getPoint().x;
        this.clickY = e.getPoint().y;
        this.dragging = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        if (this.dndPane != null) {
            Point p = SwingUtil.convertToGlassCoords((Point)e.getPoint(), (Component)this.component);
            this.dndPane.mouseReleased(p);
            this.dndPane = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 27 && this.dndPane != null) {
            this.dndPane.cancelDrag();
            e.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        if (this.dragging && Math.abs(this.clickX - p.x) + Math.abs(this.clickY - p.y) > 4) {
            if (this.owner.canDrag()) {
                Component glassPane = SwingUtil.getGlassPane((Component)this.component);
                Transferable t = this.owner.getTranferableAt(new Point(this.clickX, this.clickY));
                if (glassPane instanceof DragDropPane && t != null) {
                    this.dndPane = (DragDropPane)glassPane;
                    this.dndPane.startDrag(t, this.owner, e);
                }
            }
            this.dragging = false;
        }
        if (this.dndPane != null) {
            p = SwingUtil.convertToGlassCoords((Point)p, (Component)this.component);
            this.dndPane.mouseDragged(p);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

