/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openbp.common.ExceptionUtil;

public class SimpleTransferable
implements Transferable {
    private Object object;
    private DataFlavor[] dataflavors;

    public SimpleTransferable(Object object, DataFlavor flavor) {
        this.object = object;
        this.dataflavors = new DataFlavor[]{flavor};
    }

    public SimpleTransferable(Object object, DataFlavor[] flavors) {
        this.object = object;
        this.dataflavors = flavors;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataflavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < this.dataflavors.length; ++i) {
            if (!this.dataflavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        for (int i = 0; i < this.dataflavors.length; ++i) {
            if (!this.dataflavors[i].equals(flavor)) continue;
            return this.object;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public Object getSafeTransferData(DataFlavor flavor) {
        try {
            return this.getTransferData(flavor);
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        return null;
    }
}

