/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openbp.common.listener.AWTListenerSupport;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.VetoableEvent;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.PluginHolder;
import org.openbp.jaspira.gui.plugin.PluginPanel;
import org.openbp.jaspira.gui.plugin.TabbedPluginContainer;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.Plugin;

public abstract class AbstractVisiblePlugin
extends AbstractPlugin
implements VisiblePlugin,
HierarchyListener {
    private final PluginPanel pluginPanel;
    private final ContentPanel contentPanel = new ContentPanel(this);
    private PluginHolder holder;
    private AWTListenerSupport listenerSupport;

    public AbstractVisiblePlugin() {
        this.pluginPanel = new PluginPanel(this);
        this.setPluginHolder(this.pluginPanel);
    }

    @Override
    protected void initializeResources() {
        super.initializeResources();
        String keys = this.getPluginResourceCollection().getOptionalString("sequence");
        if (keys != null) {
            StringTokenizer sto = new StringTokenizer(keys, ",");
            KeySequence[] sequences = new KeySequence[sto.countTokens()];
            int i = 0;
            while (sto.hasMoreTokens()) {
                sequences[i] = new KeySequence(sto.nextToken());
                ++i;
            }
            JaspiraAction action = new JaspiraAction(this.getName(), this.getTitle(), this.getDescription(), null, sequences, 0, "action"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AbstractVisiblePlugin.this.focusPlugin();
                }
            };
            for (int j = 0; j < sequences.length; ++j) {
                this.addActionKeySequence(sequences[j], action);
            }
        }
    }

    @Override
    public void installPlugin() {
        super.installPlugin();
        this.pluginPanel.initTitleBar();
        this.pluginPanel.addListeners();
        this.postPluginContainerUpdate(true);
        if (ApplicationBase.isInitialized()) {
            this.applicationReady();
        }
    }

    @Override
    protected void installPluginContent() {
        super.installPluginContent();
        this.initializeComponents();
    }

    public void applicationReady() {
        JComponent comp = this.getPluginComponent();
        if (comp != null) {
            comp.addHierarchyListener(this);
        }
    }

    @Override
    public final void uninstallPlugin() {
        this.pluginPanel.removeListeners();
        super.uninstallPlugin();
        JComponent comp = this.getPluginComponent();
        if (comp != null) {
            comp.removeHierarchyListener(this);
        }
    }

    protected abstract void initializeComponents();

    @Override
    public void stackEvent(JaspiraEvent je) {
        String eventName = je.getEventName();
        if (eventName.equals("global.enviroment.rebuild")) {
            this.removeStackedEvent("global.enviroment.update");
        } else if (eventName.equals("global.enviroment.update") && this.containsStackedEvent("global.enviroment.rebuild")) {
            return;
        }
        super.stackEvent(je);
    }

    @Override
    public void pluginShown() {
        this.postPluginContainerUpdate(false);
    }

    @Override
    public void pluginHidden() {
    }

    protected boolean canPageChange(JaspiraPage oldPage, JaspiraPage newPage) {
        return true;
    }

    @Override
    public PluginPanel getPluginPanel() {
        return this.pluginPanel;
    }

    public JPanel getContentPane() {
        return this.contentPanel;
    }

    @Override
    public JComponent getPluginComponent() {
        return this.contentPanel;
    }

    @Override
    public Component getPluginFocusComponent() {
        if (this.contentPanel.getComponentCount() == 0) {
            return this.contentPanel;
        }
        Component comp = this.contentPanel.getComponent(0);
        if (comp instanceof JScrollPane) {
            return ((JScrollPane)comp).getViewport().getView();
        }
        if (comp.isFocusable()) {
            return comp;
        }
        return null;
    }

    @Override
    public void setPluginHolder(PluginHolder holder) {
        this.holder = holder;
    }

    @Override
    public PluginHolder getPluginHolder() {
        return this.holder;
    }

    @Override
    public JaspiraPage getPage() {
        for (Plugin p = this; p != null; p = p.getParentPlugin()) {
            if (!(p instanceof JaspiraPage)) continue;
            return (JaspiraPage)p;
        }
        return null;
    }

    @Override
    public int getToolbarType() {
        return 1;
    }

    @Override
    public boolean hasCloseButton() {
        return false;
    }

    @Override
    public int getSizeBehavior() {
        return 3;
    }

    @Override
    public void postPluginContainerUpdate(boolean fullRebuild) {
        String eventName;
        if (fullRebuild) {
            eventName = "global.enviroment.rebuild";
        } else {
            if (this.containsStackedEvent("global.enviroment.rebuild")) {
                return;
            }
            eventName = "global.enviroment.update";
        }
        if (this.containsStackedEvent(eventName)) {
            return;
        }
        JaspiraPage page = this.getPage();
        if (page == null) {
            return;
        }
        Window frame = page.getWindow();
        if (frame == null) {
            return;
        }
        if (fullRebuild) {
            this.removeStackedEvent("global.enviroment.update");
        }
        super.stackEvent(new JaspiraEvent(this, eventName, null, 0, 3, 2));
    }

    @Override
    public void updatePluginContainer(boolean fullRebuild) {
        if (this.holder != null) {
            this.holder.updateHolder(fullRebuild);
        }
    }

    @Override
    public JaspiraToolbar createToolbar() {
        JaspiraToolbar toolbar = null;
        switch (this.getToolbarType()) {
            case 1: {
                toolbar = new JaspiraToolbar();
                List actionNames = this.getEventActionNames();
                if (actionNames == null) break;
                int n = actionNames.size();
                for (int i = 0; i < n; ++i) {
                    String actionName = (String)actionNames.get(i);
                    toolbar.add(this.getAction(actionName));
                }
                break;
            }
            case 2: {
                InteractionEvent iae = new InteractionEvent((Plugin)this, "toolbar", null);
                this.fireEvent(iae);
                toolbar = iae.createToolbar();
            }
        }
        return toolbar;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        JComponent comp = this.getPluginComponent();
        if (comp != null) {
            if (comp.isShowing()) {
                this.pluginShown();
            } else {
                this.pluginHidden();
            }
        }
    }

    @Override
    public void showPlugin(boolean changePage) {
        if (this.holder != null && !this.isPluginVisible()) {
            this.holder.showHolder(changePage);
        }
    }

    @Override
    public boolean isPluginVisible() {
        JComponent comp = this.getPluginComponent();
        if (comp == null) {
            return false;
        }
        return comp.isShowing();
    }

    @Override
    public void focusPlugin() {
        this.showPlugin(true);
        PluginFocusMgr.getInstance().changeFocus(this);
        final Component comp = this.getPluginFocusComponent();
        if (comp != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comp.requestFocus();
                }
            });
        }
    }

    @Override
    public boolean isPluginFocused() {
        return PluginFocusMgr.getInstance().getFocusedPlugin() == this;
    }

    @Override
    public void firePluginFocusGained() {
        if (this.listenerSupport != null && this.listenerSupport.containsListeners(FocusListener.class)) {
            this.listenerSupport.fireFocusGained(new FocusEvent(this.getPluginComponent(), 1004));
        }
    }

    @Override
    public void firePluginFocusLost() {
        if (this.listenerSupport != null && this.listenerSupport.containsListeners(FocusListener.class)) {
            this.listenerSupport.fireFocusLost(new FocusEvent(this.getPluginComponent(), 1005));
        }
    }

    @Override
    public synchronized void addPluginFocusListener(FocusListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new AWTListenerSupport();
        }
        this.listenerSupport.addWeakListener(FocusListener.class, (EventListener)listener);
    }

    @Override
    public synchronized void removePluginFocusListener(FocusListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(FocusListener.class, (EventListener)listener);
        }
    }

    @Override
    public List getSubClients() {
        if (this instanceof InteractionClient) {
            return Collections.singletonList(this);
        }
        return null;
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public boolean canCopy() {
        return false;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(Transferable transferable) {
        return false;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public Transferable copy() {
        return null;
    }

    @Override
    public Transferable cut() {
        return null;
    }

    @Override
    public void paste(Transferable transferable) {
    }

    @Override
    public void delete() {
    }

    public static VisiblePlugin getPluginFromComponentHierarchy(Component c) {
        ContentPanel panel;
        Container con = SwingUtilities.getAncestorOfClass(ContentPanel.class, c);
        if (con != null && (panel = (ContentPanel)con) != null) {
            return panel.getPlugin();
        }
        return null;
    }

    private static class ContentPanel
    extends JPanel {
        private final VisiblePlugin plugin;

        public ContentPanel(VisiblePlugin plugin) {
            super(new BorderLayout());
            this.plugin = plugin;
        }

        public VisiblePlugin getPlugin() {
            return this.plugin;
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }

    public class StandardVisiblePluginEvents
    extends EventModule {
        @Override
        public String getName() {
            return "global.enviroment";
        }

        public JaspiraEventHandlerCode update(JaspiraEvent je) {
            JComponent comp = AbstractVisiblePlugin.this.getPluginComponent();
            if (comp != null && comp.isShowing()) {
                AbstractVisiblePlugin.this.updatePluginContainer(false);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode rebuild(JaspiraEvent je) {
            JComponent comp = AbstractVisiblePlugin.this.getPluginComponent();
            if (comp != null && comp.isShowing()) {
                AbstractVisiblePlugin.this.updatePluginContainer(true);
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode global_page_askchange(VetoableEvent ve) {
            if (!AbstractVisiblePlugin.this.canPageChange((JaspiraPage)ve.getOldObject(), (JaspiraPage)ve.getNewObject())) {
                ve.veto();
                return EVENT_CONSUMED;
            }
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode global_init_completed(JaspiraEvent je) {
            AbstractVisiblePlugin.this.applicationReady();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode global_plugin_addtocontainer(JaspiraEvent je) {
            if (AbstractVisiblePlugin.this.holder == AbstractVisiblePlugin.this.pluginPanel) {
                VisiblePlugin otherPlugin = (VisiblePlugin)je.getObject();
                TabbedPluginContainer tpc = AbstractVisiblePlugin.this.pluginPanel.getTabbedContainer();
                tpc.addPlugin(otherPlugin, false);
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }
    }
}

