/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.openbp.common.CommonUtil;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.action.JaspiraToolbarButton;
import org.openbp.jaspira.gui.interaction.BasicDropRegionId;
import org.openbp.jaspira.gui.interaction.CircleDropRegion;
import org.openbp.jaspira.gui.interaction.DragInitiator;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.jaspira.gui.interaction.DropClientUtil;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.interaction.RectangleSegment;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.PluginContainer;
import org.openbp.jaspira.gui.plugin.PluginHolder;
import org.openbp.jaspira.gui.plugin.PluginTransferable;
import org.openbp.jaspira.gui.plugin.TabbedPluginContainer;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.util.StandardFlavors;
import org.openbp.swing.plaf.sky.ReverseShadowBorder;

public class PluginPanel
extends JPanel
implements PluginHolder,
InteractionClient,
DragOrigin,
FocusListener,
ComponentListener,
MouseListener {
    private static final Color ACTIVE_GRADIENT_1 = new Color(133, 157, 199, 255);
    private static final Color ACTIVE_GRADIENT_2 = new Color(133, 157, 199, 0);
    private static final Color INACTIVE_GRADIENT_1 = new Color(192, 192, 192, 255);
    private static final Color INACTIVE_GRADIENT_2 = new Color(192, 192, 192, 0);
    private static final Dimension NULL_DIMENSION = new Dimension(0, 0);
    private VisiblePlugin plugin;
    private JaspiraToolbar titleBar;
    private GradientPane nameBar;
    private JLabel titleLabel;
    private JaspiraToolbarButton closeButton;
    private JToolBar cachedToolBar;
    private boolean hasCachedToolBar;
    private JPopupMenu toolbarPopup;
    private int lastWidth;
    private static ResourceCollection commonResourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("jaspira", PluginPanel.class);

    public PluginPanel(VisiblePlugin plugin) {
        super(new BorderLayout());
        this.plugin = plugin;
    }

    protected final void initTitleBar() {
        this.removeAll();
        this.titleLabel = new JLabel(null, null, 0);
        this.titleLabel.setForeground(Color.WHITE);
        this.titleLabel.setMinimumSize(NULL_DIMENSION);
        this.titleLabel.addMouseListener(this);
        this.nameBar = new GradientPane();
        this.nameBar.setToolTipText(this.plugin.getDescription());
        this.nameBar.setLayout(new FlowLayout(0, 2, 2));
        this.nameBar.addMouseListener(this);
        this.nameBar.add(this.titleLabel);
        this.titleBar = new JaspiraToolbar();
        this.titleBar.setFloatable(false);
        this.titleBar.setToolTipText(this.plugin.getDescription());
        this.titleBar.addMouseListener(this);
        this.add((Component)this.titleBar, "North");
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder((Border)new ReverseShadowBorder());
        contentPane.add(this.plugin.getPluginComponent());
        this.add((Component)contentPane, "Center");
        if (this.plugin.hasCloseButton()) {
            JaspiraAction closeAction = new JaspiraAction(commonResourceCollection, "plugin.close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginPanel.this.plugin.requestClose();
                }
            };
            contentPane.getInputMap(1).put(KeyStroke.getKeyStroke(115, 2, true), "closePlugin");
            contentPane.getActionMap().put("closePlugin", closeAction);
            this.closeButton = new JaspiraToolbarButton(closeAction);
        }
        DragInitiator.makeDraggable(this.titleLabel, this);
        DragInitiator.makeDraggable(this.titleBar, this);
        DragInitiator.makeDraggable(this.nameBar, this);
    }

    protected final void addListeners() {
        this.plugin.addPluginFocusListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    protected final void removeListeners() {
        this.plugin.removePluginFocusListener(this);
        this.removeMouseListener(this);
        this.removeComponentListener(this);
    }

    @Override
    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"plugin");
    }

    public VisiblePlugin getPlugin() {
        return this.plugin;
    }

    public TabbedPluginContainer getTabbedContainer() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof TabbedPluginContainer)) continue;
            return (TabbedPluginContainer)c;
        }
        return null;
    }

    protected void buildToolBar(boolean fullRebuild) {
        String oldTitle;
        if (this.plugin.containsStackedEvent("global.enviroment.update") || this.plugin.containsStackedEvent("global.enviroment.rebuild")) {
            return;
        }
        String title = this.plugin.getTitle();
        if (!CommonUtil.equalsNull((Object)title, (Object)(oldTitle = this.titleLabel.getText()))) {
            this.titleLabel.setText(this.plugin.getTitle());
        }
        if (this.titleBar.getComponentCount() == 0) {
            fullRebuild = true;
        }
        if (fullRebuild) {
            this.titleLabel.setIcon(this.plugin.getIcon().getIcon(16));
        }
        if (fullRebuild || !this.hasCachedToolBar) {
            JaspiraToolbar newToolBar = this.plugin.createToolbar();
            if (newToolBar != null) {
                newToolBar.setFloatable(false);
            }
            if (this.cachedToolBar != newToolBar) {
                this.cachedToolBar = newToolBar;
                fullRebuild = true;
            }
            this.hasCachedToolBar = true;
        }
        if (!fullRebuild && !this.requiresToolbarRebuildOnSizeChange()) {
            return;
        }
        this.titleBar.removeAll();
        this.titleBar.add(this.nameBar);
        if (this.cachedToolBar != null) {
            if (this.shouldDisplayToolbarPopup()) {
                if (this.toolbarPopup == null) {
                    this.toolbarPopup = new JPopupMenu();
                } else {
                    this.toolbarPopup.removeAll();
                }
                this.toolbarPopup.add(this.cachedToolBar);
                JaspiraAction toolbarPopupTrigger = new JaspiraAction(commonResourceCollection, "plugin.toolbarmenu"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dimension d = PluginPanel.this.getToolkit().getScreenSize();
                        Component c = (Component)e.getSource();
                        if (PluginPanel.this.cachedToolBar == null) {
                            return;
                        }
                        Dimension prefSize = PluginPanel.this.cachedToolBar.getPreferredSize();
                        int x = 2;
                        int y = c.getHeight() + 2;
                        if (c.getLocationOnScreen().x + prefSize.width > d.width) {
                            x -= 2 + prefSize.width;
                        }
                        PluginPanel.this.toolbarPopup.show(c, x, y);
                    }
                };
                this.titleBar.add(toolbarPopupTrigger);
            } else {
                this.toolbarPopup = null;
                this.titleBar.add(this.cachedToolBar);
            }
        }
        if (this.closeButton != null) {
            this.titleBar.add(this.closeButton);
        }
    }

    protected boolean requiresToolbarRebuildOnSizeChange() {
        boolean required = false;
        if (this.cachedToolBar != null) {
            boolean popupVisible;
            boolean showPopup = this.shouldDisplayToolbarPopup();
            boolean bl = popupVisible = this.toolbarPopup != null;
            if (showPopup != popupVisible) {
                required = true;
            }
        }
        return required;
    }

    protected boolean shouldDisplayToolbarPopup() {
        Dimension toolbarSize;
        int width;
        if (this.cachedToolBar != null && (width = this.getWidth()) >= 0 && (toolbarSize = this.cachedToolBar.getPreferredSize()) != null) {
            int remainingSize = width - this.nameBar.getPreferredSize().width;
            if (this.closeButton != null) {
                remainingSize -= this.closeButton.getPreferredSize().width;
            }
            if (remainingSize < toolbarSize.width) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateHolder(boolean fullRebuild) {
        this.buildToolBar(fullRebuild);
        TabbedPluginContainer tpc = this.getTabbedContainer();
        if (tpc != null) {
            tpc.updateContainer(fullRebuild);
        }
    }

    @Override
    public void unlinkHolder() {
        TabbedPluginContainer tpc = this.getTabbedContainer();
        if (tpc != null) {
            tpc.removePlugin(this.plugin);
        }
    }

    @Override
    public void showHolder(boolean changePage) {
        JaspiraPage page;
        TabbedPluginContainer tpc = this.getTabbedContainer();
        if (tpc != null) {
            tpc.setSelectedPlugin(this.plugin);
        }
        if (changePage && (page = this.plugin.getPage()) != null) {
            page.showPlugin(true);
        }
    }

    @Override
    public void requestFocus() {
        this.plugin.focusPlugin();
    }

    public String getTitle() {
        return this.plugin.getTitle();
    }

    public String getSubTitle() {
        return this.plugin.getSubTitle();
    }

    public String getDescription() {
        return this.plugin.getDescription();
    }

    public MultiIcon getIcon() {
        return this.plugin.getIcon();
    }

    @Override
    public void dragStarted(Transferable transferable) {
        DropClientUtil.dragStarted(this, transferable);
    }

    @Override
    public void dragEnded(Transferable transferable) {
        DropClientUtil.dragEnded(this, transferable);
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        if (flavors.contains(StandardFlavors.PLUGIN) || flavors.contains(StandardFlavors.PLUGIN_STATE)) {
            CircleDropRegion region = new CircleDropRegion(PluginContainer.REGION_CENTER, this, new RectangleSegment(this, 10, "center"), 50, this);
            region.setPaint(Color.GREEN);
            return Collections.singletonList(region);
        }
        return null;
    }

    @Override
    public final List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return DropClientUtil.getAllDropRegions(this, flavors, data, mouseEvent);
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return DropClientUtil.getAllImportersAt(this, p);
    }

    @Override
    public final boolean importData(Object regionId, Transferable data, Point p) {
        if (regionId instanceof BasicDropRegionId) {
            return this.getTabbedContainer().importData(regionId, data, p);
        }
        return false;
    }

    @Override
    public List getSubClients() {
        return this.plugin != null ? this.plugin.getSubClients() : null;
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public void dropAccepted(Transferable t) {
    }

    @Override
    public void dropCanceled(Transferable t) {
    }

    @Override
    public void dropPerformed(Transferable t) {
    }

    @Override
    public Transferable getTranferableAt(Point p) {
        if (this.plugin != null && this.plugin.canDrag()) {
            return new PluginTransferable(this.plugin);
        }
        return null;
    }

    @Override
    public MultiIcon getDragImage() {
        return this.plugin.getIcon();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.nameBar.setColors(ACTIVE_GRADIENT_1, ACTIVE_GRADIENT_2);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.nameBar.setColors(INACTIVE_GRADIENT_1, INACTIVE_GRADIENT_2);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.plugin != null && this.isVisible() && this.getWidth() != this.lastWidth) {
            this.lastWidth = this.getWidth();
            this.plugin.postPluginContainerUpdate(false);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.plugin.focusPlugin();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.plugin.focusPlugin();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class GradientPane
    extends JPanel {
        private Color gradientColor1;
        private Color gradientColor2;
        private GradientPaint gradientPaint;
        private int currentWidth;
        private int currentHeight;

        public GradientPane() {
            this.setOpaque(false);
            this.gradientColor1 = INACTIVE_GRADIENT_1;
            this.gradientColor2 = INACTIVE_GRADIENT_2;
        }

        @Override
        public void paint(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width == 0 || height == 0) {
                return;
            }
            if (this.gradientPaint == null || width != this.currentWidth || height != this.currentHeight) {
                this.gradientPaint = new GradientPaint(0.0f, 0.0f, this.gradientColor1, width, height, this.gradientColor2);
                this.currentWidth = width;
                this.currentHeight = height;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.gradientPaint);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(g);
        }

        public void setColors(Color color1, Color color2) {
            if (!this.gradientColor1.equals(color1) || !this.gradientColor2.equals(color2)) {
                this.gradientColor1 = color1;
                this.gradientColor2 = color2;
                this.gradientPaint = null;
                this.repaint();
            }
        }
    }
}

