/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option;

import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.option.widget.IntegerWidget;

public class IntegerOption
extends Option {
    private int min;
    private int max;

    public IntegerOption(ResourceCollection res, String optionName, Integer defaultValue, int min, int max) {
        super(res, optionName, defaultValue);
        this.max = max;
        this.min = min;
    }

    public IntegerOption(String optionName, String displayName, String description, Integer defaultValue, Option parent, int prio, int min, int max) {
        super(optionName, displayName, description, defaultValue, "option", parent, prio);
        this.min = min;
        this.max = max;
    }

    @Override
    public OptionWidget createOptionWidget() {
        return new IntegerWidget(this, this.min, this.max);
    }

    @Override
    public String saveToString() {
        return ((Integer)this.getValue()).toString();
    }

    @Override
    public Object loadFromString(String cryptString) {
        return new Integer(cryptString);
    }
}

