/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.tree.TreeNode;
import org.openbp.common.CommonUtil;
import org.openbp.common.setting.SettingUtil;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.option.GroupOption;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionDialog;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.swing.SwingUtil;

public final class OptionMgr
extends AbstractPlugin {
    public static final String OPTIONROOT = "optionroot";
    private static OptionMgr singletonInstance;
    private Map options = new HashMap();

    public static synchronized OptionMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new OptionMgr();
        }
        return singletonInstance;
    }

    private OptionMgr() {
        this.addOption(new GroupOption(OPTIONROOT, "", "", null, 0));
        this.initializePlugin();
        this.installPlugin();
        if (ApplicationBase.hasInstance()) {
            this.setParentPlugin(ApplicationBase.getInstance());
        }
    }

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.standard";
    }

    public Option getOption(String optionName) {
        return (Option)this.options.get(optionName);
    }

    public String getStringOption(String optionName, String dfltValue) {
        Object o;
        Option option = (Option)this.options.get(optionName);
        if (option != null && (o = option.getValue()) != null) {
            if (o instanceof String) {
                return (String)o;
            }
            System.err.println("Warning: Option '" + optionName + "' is not a string");
        }
        return dfltValue;
    }

    public boolean getBooleanOption(String optionName, boolean dfltValue) {
        Object o;
        Option option = (Option)this.options.get(optionName);
        if (option != null && (o = option.getValue()) != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            System.err.println("Warning: Option '" + optionName + "' is not a boolean");
        }
        return dfltValue;
    }

    public int getIntegerOption(String optionName, int dfltValue) {
        Object o;
        Option option = (Option)this.options.get(optionName);
        if (option != null && (o = option.getValue()) != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            System.err.println("Warning: Option '" + optionName + "' is not an integer");
        }
        return dfltValue;
    }

    public void setOption(String optionName, Object optionValue) {
        Option option = (Option)this.options.get(optionName);
        if (option != null) {
            this.setOption(option, optionValue);
        }
    }

    public void setOption(Option option, Object newValue) {
        Object oldValue = option.getValue();
        if (!CommonUtil.equalsNull((Object)oldValue, (Object)newValue)) {
            option.setValue(newValue);
            this.fireEvent(option.getName(), option);
        }
    }

    public void addOption(Option option) {
        this.options.put(option.getName(), option);
    }

    public void removeOption(Option option) {
        this.options.remove(option.getName());
    }

    public void saveOptions() {
        SettingUtil.saveSettings(null);
    }

    TreeNode createOptionTree() {
        return this.getOption(OPTIONROOT);
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "optionmanager";
        }

        @Override
        public int getPriority() {
            return 100;
        }

        public JaspiraEventHandlerCode openoptiondialog(JaspiraActionEvent je) {
            OptionDialog dlg = new OptionDialog(OptionMgr.this.getPluginResourceCollection().getRequiredString("optiondialogtitle"));
            SwingUtil.show((JDialog)dlg);
            for (Option option : OptionMgr.this.options.values()) {
                option.resetCachedOptionWidget();
            }
            return EVENT_CONSUMED;
        }
    }
}

