/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option;

import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionDialog;

public abstract class OptionWidget {
    protected Option option;

    public OptionWidget(Option option) {
        this.option = option;
    }

    public Option getOption() {
        return this.option;
    }

    public JComponent getDescriptionComponent() {
        JTextPane text = new JTextPane();
        text.setContentType("text/html");
        text.setText(this.option.getDescription());
        text.setEditable(false);
        return text;
    }

    public void notifyOptionMgrOfOptionChange() {
        for (Container c = this.getWidgetComponent(); c != null; c = c.getParent()) {
            if (!(c instanceof OptionDialog)) continue;
            OptionDialog dlg = (OptionDialog)c;
            dlg.notifyOptionChange(this);
        }
    }

    protected JLabel createHeading() {
        String heading = this.option.getHeading();
        if (heading == null) {
            return null;
        }
        JLabel label = new JLabel(heading);
        label.setBorder(new EmptyBorder(0, 0, 0, 5));
        return label;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract JComponent getWidgetComponent();
}

