/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.BorderLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.swing.plaf.sky.ReverseShadowBorder;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class IntegerSlideWidget
extends OptionWidget
implements ChangeListener {
    private Box panel;
    private JSlider slider;
    private JLabel label;

    public IntegerSlideWidget(Option option, int min, int max) {
        this(option, min, max, 0);
    }

    public IntegerSlideWidget(Option option, int min, int max, int orientation) {
        this(option, min, max, 10, orientation);
    }

    public IntegerSlideWidget(Option option, int min, int max, int steps, int orientation) {
        super(option);
        this.slider = new JSlider(orientation, min, max, min);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(this);
        JPanel labelpan = new JPanel(new BorderLayout());
        this.label = new JLabel(Integer.toString(this.slider.getValue()), 0);
        this.label.setOpaque(false);
        labelpan.setBorder((Border)new ReverseShadowBorder());
        labelpan.add(this.label);
        this.panel = Box.createVerticalBox();
        this.panel.setBorder((Border)SimpleBorder.getStandardBorder());
        this.panel.add(this.slider);
        this.panel.add(labelpan);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.label.setText(Integer.toString(this.slider.getValue()));
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public Object getValue() {
        return new Integer(this.slider.getValue());
    }

    @Override
    public void setValue(Object o) {
        this.slider.setValue((Integer)o);
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.panel;
    }
}

