/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.jaspira.option.LocalizableOptionString;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;

public class MultiCheckBoxWidget
extends OptionWidget
implements ChangeListener {
    private Box box;
    private Map checkBoxes = new HashMap();

    public MultiCheckBoxWidget(Option option, List values) {
        super(option);
        this.box = Box.createVerticalBox();
        for (Object o : values) {
            JCheckBox checkBox = new JCheckBox(o != null ? o.toString() : null);
            checkBox.setOpaque(false);
            checkBox.addChangeListener(this);
            if (o instanceof LocalizableOptionString) {
                o = ((LocalizableOptionString)o).getValue();
            }
            this.checkBoxes.put(o, checkBox);
            this.box.add(checkBox);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public Object getValue() {
        ArrayList<Integer> checked = new ArrayList<Integer>();
        for (Integer key : this.checkBoxes.keySet()) {
            if (!((JCheckBox)this.checkBoxes.get(key)).isSelected()) continue;
            checked.add(key);
        }
        return checked;
    }

    @Override
    public void setValue(Object o) {
        List list = null;
        if (o instanceof List && (list = (List)o).isEmpty()) {
            list = null;
        }
        for (Integer key : this.checkBoxes.keySet()) {
            if (list == null) {
                ((JCheckBox)this.checkBoxes.get(key)).setSelected(false);
                continue;
            }
            JCheckBox cb = (JCheckBox)this.checkBoxes.get(key);
            cb.setSelected(list.indexOf(key) != -1);
        }
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.box;
    }
}

