/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.swing.components.popupfield.JPopupField;

public class PathWidget
extends OptionWidget
implements DocumentListener {
    private JPanel panel;
    private JPopupField path;
    private FileFilter filter;
    private boolean dirSelection;
    private JFileChooser fileChooser;

    public PathWidget(Option option, FileFilter filter, boolean dirSelection) {
        super(option);
        this.filter = filter;
        this.dirSelection = dirSelection;
        this.path = new JPopupField(){

            public boolean isPopupVisible() {
                return false;
            }

            public void setPopupVisible(boolean popupVisible) {
                if (popupVisible) {
                    int retVal;
                    File f;
                    String s;
                    if (PathWidget.this.fileChooser == null) {
                        PathWidget.this.fileChooser = new JFileChooser();
                        if (PathWidget.this.filter != null) {
                            PathWidget.this.fileChooser.setFileFilter(PathWidget.this.filter);
                            PathWidget.this.fileChooser.setFileHidingEnabled(true);
                        }
                        if (PathWidget.this.dirSelection) {
                            PathWidget.this.fileChooser.setFileSelectionMode(1);
                        }
                    }
                    if ((s = this.getText()) != null && (f = new File(s)).exists()) {
                        PathWidget.this.fileChooser.setCurrentDirectory(f);
                    }
                    if ((retVal = PathWidget.this.fileChooser.showOpenDialog(null)) == 0) {
                        this.setText(PathWidget.this.fileChooser.getSelectedFile().getPath());
                    }
                }
            }
        };
        this.path.getTextField().getDocument().addDocumentListener(this);
        this.panel = new JPanel(new BorderLayout());
        JLabel heading = this.createHeading();
        if (heading != null) {
            this.panel.add((Component)heading, "West");
        }
        this.panel.add((Component)this.path);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public Object getValue() {
        String s = this.path.getText();
        if (s != null) {
            try {
                s = new File(s).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return s;
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.panel;
    }

    @Override
    public void setValue(Object o) {
        this.path.setText(o != null ? o.toString() : null);
    }
}

