/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.openbp.jaspira.option.LocalizableOptionString;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;

public class RadioWidget
extends OptionWidget
implements ActionListener {
    private Box box;
    private Map values = new HashMap();
    private Map radios = new HashMap();
    private ButtonGroup group = new ButtonGroup();

    public RadioWidget(Option option, List values) {
        super(option);
        this.box = Box.createVerticalBox();
        for (Object o : values) {
            JRadioButton radio = new JRadioButton(o != null ? o.toString() : null);
            radio.setOpaque(false);
            radio.addActionListener(this);
            if (o instanceof LocalizableOptionString) {
                o = ((LocalizableOptionString)o).getValue();
            }
            this.values.put(radio.getModel(), o);
            this.radios.put(o, radio);
            this.box.add(radio);
            this.group.add(radio);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public Object getValue() {
        return this.values.get(this.group.getSelection());
    }

    @Override
    public void setValue(Object o) {
        ((JRadioButton)this.radios.get(o)).setSelected(true);
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.box;
    }
}

