/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugin;

import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.keys.KeyMgr;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.event.KeySequenceEvent;
import org.openbp.jaspira.event.StackActionEvent;
import org.openbp.jaspira.event.VetoableEvent;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.plugin.ConfigMgr;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.ExternalEventModule;
import org.openbp.jaspira.plugin.ExternalOptionModule;
import org.openbp.jaspira.plugin.OptionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugin.PluginProfile;
import org.openbp.jaspira.plugin.PluginState;
import org.openbp.jaspira.plugins.statusbar.StatusBarTextEvent;

public abstract class AbstractPlugin
implements Plugin {
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_SEQUENCE = "sequence";
    public static final String PROPERTY_CONDITION = "condition";
    private ResourceCollection resourceCollection;
    private String name = this.getClass().getName();
    private String title;
    private String description;
    private MultiIcon icon;
    private String vendor;
    private String version;
    private String condition;
    private String uniqueId;
    private List optionModules;
    private List eventModules;
    private Map eventgroups;
    private Map foreignEvents;
    private List eventActionNames;
    private Map actionsBySequence;
    private Map peerGroups;
    private List childPlugins;
    private Plugin parent;
    private int level = 3;
    private StackPerformer stackPerformer;
    private static int instanceCounter;

    @Override
    public void initializePlugin() {
        this.initializeResources();
        this.fireEvent(new StatusBarTextEvent(this, "Loading plugin '" + this.getTitle() + "'..."));
        this.installEventModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installPlugin() {
        KeyMgr.getInstance().suspendUpdate();
        try {
            this.installPluginContent();
        }
        finally {
            KeyMgr.getInstance().resumeUpdate();
        }
        this.pluginInstalled();
    }

    protected void installPluginContent() {
        this.installActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallPlugin() {
        KeyMgr.getInstance().suspendUpdate();
        try {
            this.pluginUninstalled();
            this.uninstallActions();
            this.uninstallEventModules();
            this.setParentPlugin(null);
        }
        finally {
            KeyMgr.getInstance().resumeUpdate();
        }
    }

    @Override
    public void installFirstPlugin() {
        this.installOptionModules();
    }

    @Override
    public void uninstallLastPlugin() {
        this.uninstallOptionModules();
    }

    protected void initializeResources() {
        ResourceCollection res = this.getPluginResourceCollection();
        if (res == null) {
            res = ResourceCollectionMgr.getDefaultInstance().getResource(this.getResourceCollectionContainerName(), this.getClass());
            if (res == null) {
                throw new RuntimeException("Cannot find resource for class '" + this.getClass().getName() + "' in resource container '" + this.getResourceCollectionContainerName() + "'.");
            }
            this.setResourceCollection(res);
        }
        this.name = this.getNonNullResourceString(PROPERTY_NAME, this.name);
        this.title = this.getNonNullResourceString(PROPERTY_TITLE, this.title);
        this.description = this.getNonNullResourceString(PROPERTY_DESCRIPTION, this.description);
        this.icon = (MultiIcon)res.getRequiredObject(PROPERTY_ICON);
        this.vendor = this.getNonNullResourceString(PROPERTY_VENDOR, this.vendor);
        this.version = this.getNonNullResourceString(PROPERTY_VERSION, this.version);
        this.condition = this.getNonNullResourceString(PROPERTY_CONDITION, this.condition);
    }

    private String getNonNullResourceString(String resItemName, String dflt) {
        String s = this.getPluginResourceCollection().getOptionalString(resItemName);
        if (s != null) {
            return s;
        }
        return dflt;
    }

    protected void initializeFromPluginProfile(PluginProfile profile) {
        if (profile.getName() != null) {
            this.name = profile.getName();
        }
        if (profile.getTitle() != null) {
            this.title = profile.getTitle();
        }
        if (profile.getDescription() != null) {
            this.description = profile.getDescription();
        }
        if (profile.getVendor() != null) {
            this.vendor = profile.getVendor();
        }
        if (profile.getVersion() != null) {
            this.version = profile.getVersion();
        }
        if (profile.getCondition() != null) {
            this.condition = profile.getCondition();
        }
    }

    protected void addActionKeySequence(KeySequence sequence, JaspiraAction action) {
        if (this.actionsBySequence == null) {
            this.actionsBySequence = new HashMap();
        }
        this.actionsBySequence.put(sequence, action);
    }

    public String toString() {
        String title = this.getTitle();
        StringBuffer result = new StringBuffer(title != null ? title : "(no title)");
        result.append(" (");
        result.append(this.getUniqueId());
        result.append(" )");
        if (this.childPlugins != null) {
            result.append(" [");
            int n = this.childPlugins.size();
            for (int i = 0; i < n; ++i) {
                result.append(this.childPlugins.get(i));
            }
            result.append("]");
        }
        return result.toString();
    }

    protected void pluginInstalled() {
    }

    protected void pluginUninstalled() {
    }

    protected Class[] getExternalOptionModuleClasses() {
        return null;
    }

    protected Class[] getExternalEventModuleClasses() {
        return null;
    }

    protected Collection getExternalActions() {
        return null;
    }

    public List getSubClients() {
        if (this instanceof InteractionClient) {
            return Collections.singletonList(this);
        }
        return null;
    }

    @Override
    public boolean fireEvent(JaspiraEvent je) {
        boolean ret = false;
        ret = JaspiraEventMgr.getInstance().preHandleEvent(je) ? true : (je.getType() == 3 ? JaspiraEventMgr.getInstance().postHandleEvent(je) : this.receiveEvent(je));
        return ret;
    }

    @Override
    public boolean fireEvent(String eventName) {
        return this.fireEvent(new JaspiraEvent(this, eventName));
    }

    @Override
    public boolean fireEvent(String eventName, Object data) {
        return this.fireEvent(new JaspiraEvent(this, eventName, data));
    }

    protected boolean passDown(JaspiraEvent je) {
        Plugin ignore = je.getBrand();
        if (this.childPlugins != null) {
            for (int i = 0; i < this.childPlugins.size(); ++i) {
                Plugin child = (Plugin)this.childPlugins.get(i);
                if (ignore == child || !child.inheritEvent(je)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleEvent(JaspiraEvent je) {
        String target = je.getTargetPluginId();
        if (target != null && !target.equals(this.getUniqueId())) {
            return false;
        }
        target = je.getTargetClassName();
        if (target != null && !target.equals(this.getClass().getName())) {
            return false;
        }
        if (je.isStackable()) {
            this.stackEvent(je);
            return false;
        }
        return this.doHandleEvent(je);
    }

    boolean doHandleEvent(JaspiraEvent je) {
        Iterator it;
        Set modules;
        if (this.eventgroups != null && (modules = (Set)this.eventgroups.get(je.getEventGroup())) != null) {
            it = modules.iterator();
            while (it.hasNext()) {
                if (!((EventModule)it.next()).eventFired(je)) continue;
                return true;
            }
        }
        if (this.foreignEvents != null && (modules = (Set)this.foreignEvents.get(je.getEventName())) != null) {
            it = modules.iterator();
            while (it.hasNext()) {
                if (!((EventModule)it.next()).eventFired(je)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean receiveEvent(JaspiraEvent je) {
        if (je.getType() == 2 && this.passDown(je)) {
            return true;
        }
        if (this.handleEvent(je)) {
            return true;
        }
        if (this.getLevel() > je.getLevel() && this.getParentPlugin() != null) {
            je.brand(this);
            return this.getParentPlugin().receiveEvent(je);
        }
        return JaspiraEventMgr.getInstance().postHandleEvent(je);
    }

    @Override
    public boolean inheritEvent(JaspiraEvent je) {
        if (je.getType() == 2 && this.passDown(je)) {
            return true;
        }
        return this.handleEvent(je);
    }

    @Override
    public synchronized void stackEvent(JaspiraEvent je) {
        if (this.stackPerformer == null) {
            this.stackPerformer = new StackPerformer();
        }
        this.stackPerformer.addEvent(je);
    }

    @Override
    public synchronized boolean containsStackedEvent(String eventName) {
        if (this.stackPerformer != null) {
            return this.stackPerformer.containsEvent(eventName);
        }
        return false;
    }

    public synchronized void removeStackedEvent(String eventName) {
        if (this.stackPerformer != null) {
            this.stackPerformer.removeEvent(eventName);
        }
    }

    synchronized void clearStackPerformer() {
        this.stackPerformer = null;
    }

    synchronized void restoreStackPerformer(StackPerformer oldStackPerformer) {
        if (this.stackPerformer == null) {
            this.stackPerformer = oldStackPerformer;
        }
    }

    @Override
    public List getChildPlugins() {
        return this.childPlugins;
    }

    @Override
    public List getDescendantPlugins(List result) {
        if (result == null) {
            result = new LinkedList();
        }
        if (this.childPlugins != null) {
            result.addAll(this.childPlugins);
            for (int i = 0; i < this.childPlugins.size(); ++i) {
                Plugin child = (Plugin)this.childPlugins.get(i);
                child.getDescendantPlugins(result);
            }
        }
        return result;
    }

    @Override
    public Plugin getParentPlugin() {
        return this.parent;
    }

    @Override
    public void setParentPlugin(Plugin newParent) {
        if (this.parent != null) {
            this.parent.removePlugin(this);
        }
        this.parent = newParent;
        if (newParent != null) {
            newParent.addPlugin(this);
            this.level = newParent.getLevel() + 1;
        } else {
            this.level = 0;
        }
    }

    @Override
    public void addPlugin(Plugin child) {
        if (this.childPlugins == null) {
            this.childPlugins = new ArrayList();
        }
        this.childPlugins.add(child);
    }

    @Override
    public void removePlugin(Plugin child) {
        if (this.childPlugins != null) {
            this.childPlugins.remove(child);
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    protected boolean handleKeySequence(KeySequence ks) {
        JaspiraAction action;
        if (this.actionsBySequence != null && (action = (JaspiraAction)this.actionsBySequence.get(ks)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 0, null));
            return true;
        }
        return false;
    }

    public abstract String getResourceCollectionContainerName();

    @Override
    public ResourceCollection getPluginResourceCollection() {
        return this.resourceCollection;
    }

    public void setResourceCollection(ResourceCollection resourceCollection) {
        this.resourceCollection = resourceCollection;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getSubTitle() {
        return this.getTitle();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public MultiIcon getIcon() {
        return this.icon;
    }

    public void setIcon(MultiIcon icon) {
        this.icon = icon;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public PluginState getPluginState() {
        return new PluginState(this);
    }

    @Override
    public void setPluginState(PluginState state) {
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public final String getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = this.name + "@" + instanceCounter++;
        }
        return this.uniqueId;
    }

    protected final List getEventModules() {
        return this.eventModules;
    }

    protected final List getOptionModules() {
        return this.optionModules;
    }

    @Override
    public List getEventActionNames() {
        return this.eventActionNames;
    }

    @Override
    public JaspiraAction getAction(String actionName) {
        return ActionMgr.getInstance().getAction(actionName);
    }

    public MultiIcon getIcon(String iconName) {
        return (MultiIcon)this.getPluginResourceCollection().getRequiredObject(iconName);
    }

    @Override
    public Set getPeerGroups() {
        if (this.peerGroups == null || this.peerGroups.isEmpty()) {
            return null;
        }
        return new HashSet(this.peerGroups.values());
    }

    @Override
    public Set getPeerGroupNames() {
        if (this.peerGroups == null || this.peerGroups.isEmpty()) {
            return null;
        }
        return this.peerGroups.keySet();
    }

    @Override
    public void addToPeerGroup(String peerName, Object group) {
        if (this.peerGroups == null) {
            this.peerGroups = new HashMap();
        }
        this.peerGroups.put(peerName, group);
    }

    @Override
    public Object getPeerGroup(String peerName) {
        return this.peerGroups != null ? this.peerGroups.get(peerName) : null;
    }

    @Override
    public void removeFromPeerGroup(String peerName) {
        this.peerGroups.remove(peerName);
    }

    @Override
    public boolean matchesPeerGroup(String peerName, Object group, boolean strict) {
        if (this.peerGroups == null || this.peerGroups.isEmpty()) {
            return !strict;
        }
        if (group == null) {
            if (!strict) {
                return true;
            }
            return !this.peerGroups.containsKey(peerName);
        }
        Object o = this.peerGroups.get(peerName);
        if (o == null && !strict) {
            return true;
        }
        return group.equals(o);
    }

    @Override
    public boolean matchesPeerGroups(Plugin plugin, boolean strict) {
        if (this.peerGroups == null || this.peerGroups.isEmpty()) {
            return true;
        }
        Set those = plugin.getPeerGroups();
        if (those == null || those.isEmpty()) {
            return true;
        }
        those.retainAll(this.peerGroups.entrySet());
        if (those.isEmpty()) {
            return false;
        }
        if (!strict) {
            return true;
        }
        Set myKeys = this.getPeerGroupNames();
        myKeys.retainAll(plugin.getPeerGroupNames());
        for (String next : myKeys) {
            if (plugin.matchesPeerGroup(next, this.getPeerGroup(next), false)) continue;
            return false;
        }
        return false;
    }

    private final void installOptionModules() {
        this.optionModules = new ArrayList(1);
        Class<?>[] innerClasses = this.getClass().getClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            if (!OptionModule.class.isAssignableFrom(innerClasses[i])) continue;
            try {
                Constructor<?> ctor = innerClasses[i].getDeclaredConstructors()[0];
                OptionModule module = (OptionModule)ctor.newInstance(this);
                module.install();
                this.optionModules.add(module);
                continue;
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
        Class[] externalModules = this.getExternalOptionModuleClasses();
        if (externalModules != null) {
            for (int i = 0; i < externalModules.length; ++i) {
                Class cls = externalModules[i];
                try {
                    Constructor ctor = cls.getConstructor(Plugin.class);
                    ExternalOptionModule module = (ExternalOptionModule)ctor.newInstance(this);
                    module.install();
                    this.optionModules.add(module);
                    continue;
                }
                catch (InstantiationException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (ClassCastException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                }
            }
        }
    }

    private void uninstallOptionModules() {
        if (this.optionModules != null) {
            Iterator it = this.optionModules.iterator();
            while (it.hasNext()) {
                ((OptionModule)it.next()).uninstall();
            }
        }
    }

    private final void installEventModules() {
        this.eventModules = new ArrayList(2);
        Class<?>[] innerClasses = this.getClass().getClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            Class<?> cls = innerClasses[i];
            if (!EventModule.class.isAssignableFrom(cls)) continue;
            try {
                Constructor<?> ctor = cls.getDeclaredConstructors()[0];
                EventModule module = (EventModule)ctor.newInstance(this);
                this.eventModules.add(module);
                continue;
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
        Class[] externalModules = this.getExternalEventModuleClasses();
        if (externalModules != null) {
            for (int i = 0; i < externalModules.length; ++i) {
                Class cls = externalModules[i];
                try {
                    Constructor ctor = cls.getConstructor(Plugin.class);
                    ExternalEventModule module = (ExternalEventModule)ctor.newInstance(this);
                    this.eventModules.add(module);
                    continue;
                }
                catch (InstantiationException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                catch (ClassCastException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                }
            }
        }
        if (this.eventModules != null) {
            for (EventModule module : this.eventModules) {
                String moduleName;
                TreeSet<EventModule> modules;
                if (module.getModuleType() != 0) {
                    JaspiraEventMgr.getInstance().registerModule(module);
                    continue;
                }
                if (this.eventgroups == null) {
                    this.eventgroups = new HashMap();
                }
                if ((modules = (TreeSet<EventModule>)this.eventgroups.get(moduleName = module.getName())) == null) {
                    modules = new TreeSet<EventModule>(JaspiraEventMgr.moduleComparator);
                    this.eventgroups.put(moduleName, modules);
                }
                modules.add(module);
                List foreignEventNames = module.getForeignEventNames();
                if (foreignEventNames == null) continue;
                if (this.foreignEvents == null) {
                    this.foreignEvents = new HashMap();
                }
                int n = foreignEventNames.size();
                for (int i = 0; i < n; ++i) {
                    String event = (String)foreignEventNames.get(i);
                    TreeSet<EventModule> foreignModules = (TreeSet<EventModule>)this.foreignEvents.get(event);
                    if (foreignModules == null) {
                        foreignModules = new TreeSet<EventModule>(JaspiraEventMgr.moduleComparator);
                        this.foreignEvents.put(event, foreignModules);
                    }
                    foreignModules.add(module);
                }
            }
        }
    }

    private void uninstallEventModules() {
        for (EventModule module : this.getEventModules()) {
            if (module.getModuleType() == 0) continue;
            JaspiraEventMgr.getInstance().unregisterModule(module);
        }
    }

    private final void installActions() {
        Collection externalActions;
        if (this.eventModules != null) {
            for (EventModule module : this.eventModules) {
                List actionNames = module.getEventActionNames();
                if (actionNames == null) continue;
                int n = actionNames.size();
                for (int i = 0; i < n; ++i) {
                    String actionName = (String)actionNames.get(i);
                    JaspiraAction action = new JaspiraAction(this, actionName);
                    if (!this.installAction(action)) continue;
                    if (this.eventActionNames == null) {
                        this.eventActionNames = new ArrayList();
                    }
                    this.eventActionNames.add(actionName);
                }
            }
        }
        if ((externalActions = this.getExternalActions()) != null) {
            for (JaspiraAction action : externalActions) {
                this.installAction(action);
            }
        }
        if (this.actionsBySequence != null) {
            KeyMgr.getInstance().addSequences(this.actionsBySequence.keySet().iterator());
        }
    }

    private boolean installAction(JaspiraAction action) {
        if (!ConfigMgr.getInstance().evaluate(action.getCondition())) {
            return false;
        }
        KeySequence[] sequence = action.getKeySequences();
        if (sequence != null && sequence.length > 0) {
            for (int j = 0; j < sequence.length; ++j) {
                this.addActionKeySequence(sequence[j], action);
            }
        }
        ActionMgr.getInstance().addAction(action);
        return true;
    }

    private void uninstallActions() {
        if (this.actionsBySequence != null) {
            KeyMgr.getInstance().removeSequences(this.actionsBySequence.keySet().iterator());
        }
        ActionMgr actionMgr = ActionMgr.getInstance();
        if (this.eventActionNames != null) {
            Iterator it = this.eventActionNames.iterator();
            while (it.hasNext()) {
                actionMgr.removeAction((String)it.next());
            }
        }
        actionMgr.removeAllActions(this.getExternalActions());
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public boolean requestClose() {
        VetoableEvent ve = new VetoableEvent(this, "global.askclose");
        this.inheritEvent(ve);
        if (ve.isVetoed()) {
            this.inheritEvent(new JaspiraEvent(this, "global.closecanceled"));
            return false;
        }
        StackActionEvent sae = new StackActionEvent(this, "global.doclose");
        this.inheritEvent(sae);
        sae.performActions();
        return true;
    }

    void doClose() {
        this.preClose();
        PluginMgr.getInstance().removeInstance(this);
    }

    protected void preClose() {
    }

    protected void closeCanceled() {
    }

    public class StandardPluginEvents
    extends EventModule {
        @Override
        public String getName() {
            return "global.page";
        }

        public JaspiraEventHandlerCode global_askclose(VetoableEvent ve) {
            if (!AbstractPlugin.this.canClose()) {
                ve.veto();
                return EVENT_CONSUMED;
            }
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode global_doclose(StackActionEvent ve) {
            ve.addAction(new Runnable(){

                @Override
                public void run() {
                    AbstractPlugin.this.doClose();
                }
            });
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode global_closecanceled(JaspiraEvent ve) {
            AbstractPlugin.this.closeCanceled();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode global_keyevent(KeySequenceEvent kse) {
            return AbstractPlugin.this.handleKeySequence(kse.getKeySequence()) ? EventModule.EVENT_CONSUMED : EventModule.EVENT_IGNORED;
        }
    }

    private class StackPerformer
    implements Runnable {
        private Map eventStack;

        StackPerformer() {
        }

        public synchronized void addEvent(JaspiraEvent je) {
            if (this.eventStack == null) {
                this.eventStack = new LinkedHashMap();
            }
            if (this.eventStack.isEmpty()) {
                SwingUtilities.invokeLater(this);
            }
            this.eventStack.put(je.getEventName(), je);
        }

        public boolean containsEvent(String eventName) {
            return this.eventStack != null && this.eventStack.get(eventName) != null;
        }

        public synchronized void removeEvent(String eventName) {
            if (this.eventStack != null) {
                this.eventStack.remove(eventName);
            }
        }

        @Override
        public synchronized void run() {
            AbstractPlugin.this.clearStackPerformer();
            for (JaspiraEvent je : this.eventStack.values()) {
                AbstractPlugin.this.doHandleEvent(je);
            }
            this.eventStack.clear();
            AbstractPlugin.this.restoreStackPerformer(this);
        }
    }
}

