/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugins.propertybrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginState;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserPluginState;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSaveEvent;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSetEvent;
import org.openbp.jaspira.propertybrowser.ObjectChangeListener;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserEvent;
import org.openbp.jaspira.propertybrowser.PropertyBrowserImpl;
import org.openbp.jaspira.propertybrowser.PropertyBrowserListener;
import org.openbp.jaspira.propertybrowser.SaveStrategy;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class PropertyBrowserPlugin
extends AbstractVisiblePlugin
implements ObjectChangeListener,
SaveStrategy,
PropertyBrowserListener,
FocusListener {
    private MultiIcon icon;
    private String titleBase;
    private String title;
    private String subTitle;
    private String description;
    private String readonlyText;
    private String modifiedText;
    private JComponent errorPane;
    private PropertyBrowserImpl propertyBrowser;
    private PropertyBrowserPluginState newState;
    private PropertyBrowserPluginState currentState;
    private static SimpleBorder errorBorder;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.standard";
    }

    @Override
    public void initializePlugin() {
        super.initializePlugin();
        this.newState = new PropertyBrowserPluginState(this);
        this.propertyBrowser = new PluginPropertyBrowser(this, this.getPluginResourceCollection());
        this.propertyBrowser.setShowTooltips(false);
        this.propertyBrowser.addObjectChangeListener(this);
        this.propertyBrowser.addPropertyBrowserListener(this);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.propertyBrowser));
        this.getContentPane().add(scrollPane);
        this.errorPane = scrollPane;
        if (errorBorder == null) {
            errorBorder = new SimpleBorder(2, 2, 2, 2);
            errorBorder.setWidth(2);
            errorBorder.setColor(Color.RED);
        }
        this.subTitle = this.getPluginResourceCollection().getOptionalString("title");
        this.readonlyText = this.getPluginResourceCollection().getOptionalString("plugin.propertybrowser.readonly");
        if (this.readonlyText != null) {
            this.readonlyText = " " + this.readonlyText;
        }
        this.modifiedText = this.getPluginResourceCollection().getOptionalString("plugin.propertybrowser.modified");
        if (this.modifiedText != null) {
            this.modifiedText = " " + this.modifiedText;
        }
    }

    @Override
    protected void initializeComponents() {
    }

    @Override
    protected Collection getExternalActions() {
        ArrayList<JaspiraAction> list = new ArrayList<JaspiraAction>();
        list.add(this.propertyBrowser.getAddAction());
        list.add(this.propertyBrowser.getCopyAction());
        list.add(this.propertyBrowser.getCutAction());
        list.add(this.propertyBrowser.getPasteAction());
        list.add(this.propertyBrowser.getRemoveAction());
        list.add(this.propertyBrowser.getMoveUpAction());
        list.add(this.propertyBrowser.getMoveDownAction());
        return list;
    }

    @Override
    public boolean hasCloseButton() {
        return false;
    }

    @Override
    public int getToolbarType() {
        return 2;
    }

    @Override
    public String getSubTitle() {
        return this.subTitle != null ? this.subTitle : this.getTitle();
    }

    @Override
    protected boolean canPageChange(JaspiraPage oldPage, JaspiraPage newPage) {
        return this.propertyBrowser.saveObject();
    }

    @Override
    public PluginState getPluginState() {
        if (this.newState != null) {
            return this.newState;
        }
        return this.currentState;
    }

    @Override
    public void setPluginState(PluginState state) {
        super.setPluginState(state);
        this.newState = (PropertyBrowserPluginState)state;
        if (this.newState == null || this.propertyBrowser == null) {
            return;
        }
        try {
            this.propertyBrowser.setObject(this.newState.unmodifiedObject, this.newState.modifiedObject, this.newState.isObjectNew, this.icon, null);
            this.propertyBrowser.setOriginalObject(this.newState.originalObject);
            if (this.propertyBrowser.getModifiedObject() == null) {
                this.titleBase = this.newState.title;
                this.description = this.newState.description;
                this.icon = this.newState.icon;
                this.propertyBrowser.setReadOnly(this.newState.readOnly);
                this.propertyBrowser.setSaveImmediately(this.newState.saveImmediately);
                this.errorPane.setBorder(null);
                this.updateTitle();
                this.updatePluginContainer(false);
                if (this.newState != null && this.newState.unmodifiedObject != null) {
                    this.showPlugin(false);
                }
            }
            this.currentState = this.newState;
            this.newState = null;
        }
        catch (XMLDriverException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (CloneNotSupportedException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    public Object getCurrentObject() {
        if (this.newState != null) {
            return this.newState.unmodifiedObject;
        }
        return this.propertyBrowser.getObject();
    }

    @Override
    public boolean executeSave(PropertyBrowser editor) {
        Object modObject = editor.getModifiedObject();
        PropertyBrowserSaveEvent oee = new PropertyBrowserSaveEvent((Plugin)this, "plugin.propertybrowser.executesave", modObject, editor.getObject());
        this.fireEvent(oee);
        if (!oee.saved) {
            this.errorPane.setBorder((Border)errorBorder);
        } else {
            this.propertyBrowser.setObjectModified(false);
        }
        this.updateStatus();
        return oee.saved;
    }

    @Override
    public void objectChanged(Object original, Object modified) {
        this.updateStatus();
    }

    @Override
    public void handlePropertyBrowserEvent(PropertyBrowserEvent e) {
        switch (e.eventType) {
            case 2: 
            case 3: {
                if (e.node == null) break;
                Object eventArg = null;
                eventArg = e.node instanceof ObjectNode ? ((ObjectNode)e.node).getObject() : e.node.getColumnValue(0);
                if (!(eventArg instanceof DescriptionObject)) break;
                this.fireEvent(new JaspiraEvent(this, "plugin.infopanel.setinfotext", eventArg));
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.fireEvent(new JaspiraEvent(this, "plugin.infopanel.clearinfotext", null));
    }

    private void updateStatus() {
        if (this.updateTitle()) {
            this.updatePluginContainer(false);
        }
    }

    private boolean updateTitle() {
        String newTitle;
        String string = newTitle = this.titleBase != null ? this.titleBase : "";
        if (this.propertyBrowser.isReadOnly() && this.readonlyText != null) {
            newTitle = newTitle + this.readonlyText;
        }
        if (this.propertyBrowser.isObjectModified() && this.modifiedText != null) {
            newTitle = newTitle + this.modifiedText;
        }
        if (this.title == null || !this.title.equals(newTitle)) {
            this.title = newTitle;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return super.getTitle();
        }
        return this.title;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return super.getDescription();
        }
        return this.description;
    }

    @Override
    public MultiIcon getIcon() {
        if (this.icon == null) {
            return super.getIcon();
        }
        return this.icon;
    }

    private class PluginPropertyBrowser
    extends PropertyBrowserImpl {
        public PluginPropertyBrowser(SaveStrategy saveStrategy, ResourceCollection res) {
            super(saveStrategy, res);
        }

        @Override
        public boolean saveObject() {
            boolean ret = super.saveObject();
            if (!ret) {
                PropertyBrowserPlugin.this.errorPane.setBorder((Border)errorBorder);
            } else {
                PropertyBrowserPlugin.this.errorPane.setBorder(null);
            }
            return ret;
        }
    }

    public class SaveEvents
    extends EventModule {
        @Override
        public String getName() {
            return "standard.file";
        }

        @Override
        public int getPriority() {
            return 25;
        }

        public JaspiraEventHandlerCode save(JaspiraActionEvent jae) {
            if (!PropertyBrowserPlugin.this.getPluginComponent().isShowing()) {
                return EVENT_IGNORED;
            }
            if (PropertyBrowserPlugin.this.propertyBrowser != null) {
                PropertyBrowserPlugin.this.propertyBrowser.saveObject();
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.propertybrowser";
        }

        public synchronized JaspiraEventHandlerCode setobject(PropertyBrowserSetEvent oe) {
            if (PropertyBrowserPlugin.this.propertyBrowser != null && !PropertyBrowserPlugin.this.propertyBrowser.saveObject()) {
                return EVENT_CONSUMED;
            }
            Object newObject = oe.getObject();
            if (!oe.reedit && newObject == PropertyBrowserPlugin.this.getCurrentObject()) {
                return EVENT_CONSUMED;
            }
            PropertyBrowserPluginState state = new PropertyBrowserPluginState(PropertyBrowserPlugin.this);
            state.unmodifiedObject = newObject;
            state.originalObject = oe.originalObject;
            state.modifiedObject = null;
            state.isObjectNew = oe.isObjectNew;
            state.title = oe.title;
            state.description = oe.description;
            state.icon = oe.icon;
            state.readOnly = oe.readOnly;
            state.saveImmediately = oe.saveImmediately;
            PropertyBrowserPlugin.this.setPluginState(state);
            return EVENT_CONSUMED;
        }

        public synchronized JaspiraEventHandlerCode refresh(JaspiraEvent je) {
            if (PropertyBrowserPlugin.this.propertyBrowser != null && !PropertyBrowserPlugin.this.propertyBrowser.saveObject()) {
                return EVENT_HANDLED;
            }
            PropertyBrowserPlugin.this.setPluginState(PropertyBrowserPlugin.this.currentState);
            return EVENT_HANDLED;
        }
    }

    public class InteractionEvents
    extends InteractionModule {
        @Override
        public JaspiraEventHandlerCode toolbar(InteractionEvent ie) {
            if (ie.getSourcePlugin() != PropertyBrowserPlugin.this) {
                return EVENT_IGNORED;
            }
            JaspiraAction group = new JaspiraAction("propertybrowser.modify", null, null, null, null, 1, "group");
            group.addToolbarChild(PropertyBrowserPlugin.this.propertyBrowser.getAddAction());
            group.addToolbarChild(PropertyBrowserPlugin.this.propertyBrowser.getCopyAction());
            group.addToolbarChild(PropertyBrowserPlugin.this.propertyBrowser.getCutAction());
            group.addToolbarChild(PropertyBrowserPlugin.this.propertyBrowser.getPasteAction());
            group.addToolbarChild(PropertyBrowserPlugin.this.propertyBrowser.getRemoveAction());
            ie.add(group);
            group = new JaspiraAction("propertybrowser.order", null, null, null, null, 1, "group");
            group.addToolbarChild(PropertyBrowserPlugin.this.propertyBrowser.getMoveUpAction());
            group.addToolbarChild(PropertyBrowserPlugin.this.propertyBrowser.getMoveDownAction());
            ie.add(group);
            group = new JaspiraAction("propertybrowser.save", null, null, null, null, 1, "group");
            group.addToolbarChild(PropertyBrowserPlugin.this.getAction("standard.file.save"));
            ie.add(group);
            return EVENT_HANDLED;
        }
    }
}

