/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser;

import java.util.HashMap;
import java.util.Map;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptorMgr;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;

public final class NodeStructureMgr {
    private static NodeStructureMgr singletonInstance;
    private Map nodeStructureMap;

    private NodeStructureMgr() {
    }

    public static synchronized NodeStructureMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new NodeStructureMgr();
        }
        return singletonInstance;
    }

    public ObjectNode createEditorStructureFor(Class classType) {
        ObjectNode node = this.obtainStructure(classType);
        if (node != null) {
            try {
                return (ObjectNode)node.clone();
            }
            catch (CloneNotSupportedException ex) {
                ExceptionUtil.printTrace((Throwable)ex);
            }
        }
        return null;
    }

    public void loadNodeStructureFor(Class classType) {
        this.obtainStructure(classType);
    }

    public void clearCache() {
        this.nodeStructureMap = null;
    }

    private ObjectNode obtainStructure(Class classType) {
        ObjectNode node;
        if (this.nodeStructureMap == null) {
            this.nodeStructureMap = new HashMap();
        }
        if ((node = (ObjectNode)this.nodeStructureMap.get(classType)) != null) {
            return node;
        }
        try {
            ObjectDescriptor objectDescriptor = ObjectDescriptorMgr.getInstance().getDescriptor(classType, 1);
            node = new ObjectNode(objectDescriptor);
            if (node != null) {
                this.nodeStructureMap.put(classType, node);
            }
            return node;
        }
        catch (XMLDriverException ex) {
            ExceptionUtil.printTrace((Throwable)ex);
            return null;
        }
    }
}

