/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.editor;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.property.PropertyAccessUtil;
import org.openbp.common.property.PropertyException;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserEvent;
import org.openbp.jaspira.propertybrowser.editor.EditorParameterParser;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditorListener;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditorOwner;
import org.openbp.jaspira.propertybrowser.editor.PropertyValidator;

public abstract class AbstractPropertyEditor
implements PropertyEditor,
KeyListener,
FocusListener {
    protected String propertyName;
    protected String params;
    protected boolean readonly;
    protected PropertyValidator validator;
    protected PropertyEditorListener listener;
    protected PropertyEditorOwner owner;
    protected JComponent component;
    protected EditorParameterParser parameterParser;
    protected PropertyBrowser propertyBrowser;
    protected Object object;
    protected Object value;
    protected boolean valueLoaded;
    protected boolean valueChanged;
    private boolean performingSaveProperty;

    @Override
    public void initialize(String params) {
        this.params = params;
    }

    public Object clone() throws CloneNotSupportedException {
        PropertyEditor clone = (PropertyEditor)super.clone();
        clone.copyFrom(this, 2);
        return clone;
    }

    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        AbstractPropertyEditor src = (AbstractPropertyEditor)source;
        this.validator = src.validator;
        this.readonly = src.readonly;
        this.propertyName = src.propertyName;
        this.params = src.params;
        this.component = null;
        this.object = null;
        this.valueChanged = false;
    }

    public EditorParameterParser getParameterParser() {
        return this.parameterParser;
    }

    protected abstract void setComponentValue();

    protected abstract Object getComponentValue();

    protected abstract void createComponent();

    protected void highlight(boolean on) {
    }

    @Override
    public void propertyChanged() {
        this.value = this.getComponentValue();
        this.valueChanged = true;
        if (!this.validateProperty(false)) {
            return;
        }
        if (this.listener != null) {
            this.listener.componentCreated(this);
        }
        this.propertyBrowser.firePropertyBrowserEvent(new PropertyBrowserEvent(5, this));
    }

    @Override
    public void loadProperty() {
        try {
            this.value = PropertyAccessUtil.getProperty((Object)this.object, (String)this.propertyName);
            this.valueLoaded = true;
            this.valueChanged = false;
            this.setComponentValue();
        }
        catch (PropertyException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveProperty() {
        if (this.performingSaveProperty) {
            return false;
        }
        if (this.valueChanged && this.object != null) {
            this.performingSaveProperty = true;
            try {
                if (!this.validateProperty(true)) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.valueChanged = false;
                    PropertyAccessUtil.setProperty((Object)this.object, (String)this.propertyName, (Object)this.value);
                    this.propertyBrowser.firePropertyBrowserEvent(new PropertyBrowserEvent(6, this));
                }
                catch (PropertyException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    boolean bl = false;
                    this.performingSaveProperty = false;
                    return bl;
                }
            }
            finally {
                this.performingSaveProperty = false;
            }
        }
        return true;
    }

    @Override
    public void resetProperty() {
        this.loadProperty();
        this.highlight(true);
    }

    protected boolean validateProperty(boolean complete) {
        if (this.valueChanged) {
            PropertyValidator ownerValidator;
            if (this.validator != null && !this.validator.validateProperty(this.propertyName, this.value, this.object, this, complete)) {
                return false;
            }
            if (this.owner != null && (ownerValidator = this.owner.getValidator()) != null && !ownerValidator.validateProperty(this.propertyName, this.value, this.object, this, complete)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public JComponent getPropertyComponent() {
        if (this.object != null) {
            this.initializeComponent();
            if (!this.valueLoaded) {
                this.loadProperty();
            }
        }
        return this.component;
    }

    @Override
    public JComponent getComponent() {
        if (this.object != null) {
            this.initializeComponent();
        }
        return this.component;
    }

    protected void initializeComponent() {
        if (this.component == null) {
            if (this.getParams() != null) {
                this.parameterParser = new EditorParameterParser(this);
                String className = this.parameterParser.getString("listener");
                if (className != null) {
                    try {
                        this.listener = (PropertyEditorListener)ReflectUtil.instantiate((String)className, PropertyEditorListener.class, (String)"property editor listener");
                    }
                    catch (Exception e) {
                        ExceptionUtil.printTrace((Throwable)e);
                    }
                }
                this.parseParams(this.parameterParser);
            }
            if (this.listener != null) {
                this.listener.initialized(this);
            }
            this.createComponent();
            if (this.listener != null) {
                this.listener.componentCreated(this);
            }
        }
    }

    @Override
    public void resetComponentDisplay() {
        this.highlight(false);
    }

    protected void parseParams(EditorParameterParser parser) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 27 && this.valueChanged) {
            this.loadProperty();
            this.highlight(true);
            e.consume();
            return;
        }
        if (keyCode == 9 || keyCode == 10 || keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40 || keyCode == 36 || keyCode == 35 || keyCode == 33 || keyCode == 34 || keyCode == 27) {
            this.forwardKeyEvent(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.propertyBrowser.firePropertyBrowserEvent(new PropertyBrowserEvent(3, this));
        this.highlight(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.highlight(false);
        this.propertyBrowser.firePropertyBrowserEvent(new PropertyBrowserEvent(4, this));
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.valueLoaded = false;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
        this.valueLoaded = false;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public String getParams() {
        return this.params;
    }

    @Override
    public void setParams(String params) {
        this.params = params;
    }

    @Override
    public PropertyValidator getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(PropertyValidator validator) {
        this.validator = validator;
    }

    @Override
    public PropertyEditorOwner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(PropertyEditorOwner owner) {
        this.owner = owner;
    }

    @Override
    public PropertyBrowser getPropertyBrowser() {
        return this.propertyBrowser;
    }

    @Override
    public void setPropertyBrowser(PropertyBrowser propertyBrowser) {
        this.propertyBrowser = propertyBrowser;
    }

    protected String getSafeString(Object value) {
        return value != null ? value.toString() : null;
    }

    protected void forwardKeyEvent(KeyEvent e) {
        if (this.owner != null) {
            this.owner.handleKeyEvent(e);
        }
        e.consume();
    }
}

